/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InheritanceType implements Enumerator
{
    DEFAULT(0, "Default", "Default (Single Table)"),
    SINGLE_TABLE(1, "SINGLE_TABLE", "Single Table"),
    JOINED(2, "JOINED", "Joined"),
    TABLE_PER_CLASS(3, "TABLE_PER_CLASS", "Table per Class");

    public static final int DEFAULT_VALUE = 0;
    public static final int SINGLE_TABLE_VALUE = 1;
    public static final int JOINED_VALUE = 2;
    public static final int TABLE_PER_CLASS_VALUE = 3;
    private static final InheritanceType[] VALUES_ARRAY;
    public static final List<InheritanceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InheritanceType[]{DEFAULT, SINGLE_TABLE, JOINED, TABLE_PER_CLASS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InheritanceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InheritanceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InheritanceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InheritanceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InheritanceType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return SINGLE_TABLE;
            }
            case 2: {
                return JOINED;
            }
            case 3: {
                return TABLE_PER_CLASS;
            }
        }
        return null;
    }

    private InheritanceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static InheritanceType fromJavaAnnotationValue(Object javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            return DEFAULT;
        }
        if (javaAnnotationValue.equals("javax.persistence.InheritanceType.JOINED")) {
            return JOINED;
        }
        if (javaAnnotationValue.equals("javax.persistence.InheritanceType.SINGLE_TABLE")) {
            return SINGLE_TABLE;
        }
        if (javaAnnotationValue.equals("javax.persistence.InheritanceType.TABLE_PER_CLASS")) {
            return TABLE_PER_CLASS;
        }
        return DEFAULT;
    }

    public String convertToJavaAnnotationValue() {
        switch (this.getValue()) {
            case 0: {
                return null;
            }
            case 2: {
                return "javax.persistence.InheritanceType.JOINED";
            }
            case 1: {
                return "javax.persistence.InheritanceType.SINGLE_TABLE";
            }
            case 3: {
                return "javax.persistence.InheritanceType.TABLE_PER_CLASS";
            }
        }
        throw new IllegalArgumentException("unknown inheritance type: " + (Object)((Object)this));
    }

    public boolean isSingleTable() {
        return this.getValue() == 0 || this.getValue() == 1;
    }
}

