/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbedded;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOverride;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEmbedded;
import org.eclipse.jpt.core.internal.platform.AttributeOverrideContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaAttributeContext;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEmbeddedContext
extends JavaAttributeContext {
    private Collection<AttributeOverrideContext> attributeOverrideContexts = this.buildAttributeOverrideContexts();

    public JavaEmbeddedContext(IContext parentContext, JavaEmbedded javaEmbedded) {
        super(parentContext, javaEmbedded);
    }

    protected Collection<AttributeOverrideContext> buildAttributeOverrideContexts() {
        ArrayList<AttributeOverrideContext> contexts = new ArrayList<AttributeOverrideContext>();
        for (IAttributeOverride attributeOverride : this.getEmbedded().getAttributeOverrides()) {
            contexts.add(new AttributeOverrideContext(this, attributeOverride));
        }
        return contexts;
    }

    private IEmbedded getEmbedded() {
        return (IEmbedded)this.getMapping();
    }

    @Override
    protected void refreshDefaultsInternal(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaultsInternal(defaultsContext, monitor);
        this.refreshDefaultAttributeOverrides();
        for (AttributeOverrideContext context : this.attributeOverrideContexts) {
            context.refreshDefaults(defaultsContext, monitor);
        }
    }

    protected void refreshDefaultAttributeOverrides() {
        Iterator<String> i = this.getEmbedded().allOverridableAttributeNames();
        while (i.hasNext()) {
            String override = i.next();
            if (this.getEmbedded().containsAttributeOverride(override)) continue;
            IAttributeOverride attributeOverride = JpaJavaMappingsFactory.eINSTANCE.createJavaAttributeOverride(new IEmbedded.AttributeOverrideOwner(this.getEmbedded()), this.getEmbedded().getPersistentAttribute().getAttribute());
            this.getEmbedded().getDefaultAttributeOverrides().add((Object)attributeOverride);
            ((JavaOverride)((Object)attributeOverride)).setName(override);
        }
        Collection attributeNames = CollectionTools.collection(this.getEmbedded().allOverridableAttributeNames());
        ArrayList<IAttributeOverride> overridesToRemove = new ArrayList<IAttributeOverride>();
        for (IAttributeOverride attributeOverride : this.getEmbedded().getDefaultAttributeOverrides()) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.getEmbedded().containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            overridesToRemove.add(attributeOverride);
        }
        this.getEmbedded().getDefaultAttributeOverrides().removeAll(overridesToRemove);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        for (AttributeOverrideContext aoContext : this.attributeOverrideContexts) {
            aoContext.addToMessages(messages);
        }
    }
}

