/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContextWrapper;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JoinColumnContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableContext
extends BaseContext {
    private IJoinTable table;
    private Collection<JoinColumnContext> joinColumnContexts;
    private Collection<JoinColumnContext> inverseJoinColumnContexts;
    private boolean doContinue;

    public JoinTableContext(IContext parentContext, IJoinTable table) {
        super(parentContext);
        this.table = table;
        this.joinColumnContexts = this.buildJoinColumnContexts();
        this.inverseJoinColumnContexts = this.buildInverseJoinColumnContexts();
    }

    @Override
    protected void initialize() {
    }

    protected Collection<JoinColumnContext> buildJoinColumnContexts() {
        ArrayList<JoinColumnContext> contexts = new ArrayList<JoinColumnContext>();
        for (IJoinColumn joinColumn : this.table.getJoinColumns()) {
            contexts.add(this.buildJoinColumnContext(joinColumn));
        }
        return contexts;
    }

    protected JoinColumnContext buildJoinColumnContext(IJoinColumn joinColumn) {
        return new JoinColumnContext((IContext)this, joinColumn);
    }

    protected Collection<JoinColumnContext> buildInverseJoinColumnContexts() {
        ArrayList<JoinColumnContext> contexts = new ArrayList<JoinColumnContext>();
        for (IJoinColumn joinColumn : this.table.getInverseJoinColumns()) {
            contexts.add(this.buildInverseJoinColumnContext(joinColumn));
        }
        return contexts;
    }

    protected JoinColumnContext buildInverseJoinColumnContext(IJoinColumn joinColumn) {
        return new JoinColumnContext((IContext)this, joinColumn);
    }

    public IJoinTable getTable() {
        return this.table;
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        this.table.refreshDefaults(this.wrapDefaultsContext(defaultsContext));
        DefaultsContext joinColumnsDefaultsContext = this.wrapDefaultsContextForJoinColumn(defaultsContext);
        for (JoinColumnContext context : this.joinColumnContexts) {
            context.refreshDefaults(joinColumnsDefaultsContext, monitor);
        }
        DefaultsContext inverseJoinColumnsDefaultsContext = this.wrapDefaultsContextForInverseJoinColumn(defaultsContext);
        for (JoinColumnContext context : this.inverseJoinColumnContexts) {
            context.refreshDefaults(inverseJoinColumnsDefaultsContext, monitor);
        }
    }

    protected DefaultsContext wrapDefaultsContext(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                if (key.equals("joinTable.name")) {
                    return JoinTableContext.this.joinTableDefaultName(this);
                }
                return super.getDefault(key);
            }
        };
    }

    protected DefaultsContext wrapDefaultsContextForJoinColumn(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                if (key.equals("joinColumn.table")) {
                    return JoinTableContext.this.getTable().getName();
                }
                return super.getDefault(key);
            }
        };
    }

    protected String joinTableDefaultName(DefaultsContext defaultsContext) {
        String tableName = this.relationshipMapping().typeMapping().getTableName();
        if (tableName == null) {
            return null;
        }
        IEntity targetEntity = this.targetEntity(defaultsContext);
        if (targetEntity == null) {
            return null;
        }
        ITable targetTable = targetEntity.getTable();
        return targetTable == null ? null : String.valueOf(tableName) + "_" + targetTable.getName();
    }

    protected IEntity targetEntity(DefaultsContext defaultsContext) {
        String targetEntity = this.relationshipMapping().fullyQualifiedTargetEntity(defaultsContext.astRoot());
        if (targetEntity == null) {
            return null;
        }
        IPersistentType persistentType = defaultsContext.persistentType(targetEntity);
        if (persistentType == null) {
            return null;
        }
        ITypeMapping typeMapping = persistentType.getMapping();
        if (typeMapping instanceof IEntity) {
            return (IEntity)typeMapping;
        }
        return null;
    }

    protected IRelationshipMapping relationshipMapping() {
        return this.table.relationshipMapping();
    }

    protected DefaultsContext wrapDefaultsContextForInverseJoinColumn(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                if (key.equals("joinColumn.table")) {
                    return JoinTableContext.this.getTable().getName();
                }
                return super.getDefault(key);
            }
        };
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addTableMessages(messages);
        if (this.doContinue) {
            for (JoinColumnContext context : this.joinColumnContexts) {
                context.addToMessages(messages);
            }
            for (JoinColumnContext context : this.inverseJoinColumnContexts) {
                context.addToMessages(messages);
            }
        }
    }

    protected void addTableMessages(List<IMessage> messages) {
        this.doContinue = this.table.isConnected();
        String schema = this.table.getSchema();
        XmlRelationshipMapping mapping = (XmlRelationshipMapping)this.table.relationshipMapping();
        if (this.doContinue && !this.table.hasResolvedSchema()) {
            if (mapping.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{mapping.getPersistentAttribute().getName(), schema, this.table.getName()}, this.table, this.table.schemaTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.table.getName()}, this.table, this.table.schemaTextRange()));
            }
            this.doContinue = false;
        }
        if (this.doContinue && !this.table.isResolved()) {
            if (mapping.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME", new String[]{mapping.getPersistentAttribute().getName(), this.table.getName()}, this.table, this.table.nameTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_NAME", new String[]{this.table.getName()}, this.table, this.table.nameTextRange()));
            }
        }
    }
}

