/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.validation;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.JpaProject;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.validation.JpaHelper;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class JpaValidator
implements IValidatorJob {
    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return ((IWorkbenchContext)helper).getProject();
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        JpaHelper jpaHelper = (JpaHelper)helper;
        IJpaProject jpaProject = jpaHelper.getJpaProject();
        if (!((JpaProject)jpaProject).isFilled()) {
            try {
                JpaModelManager.instance().fillJpaProject(jpaProject.getProject());
            }
            catch (CoreException ce) {
                return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.ERROR_SYNCHRONIZING_CLASSES_COULD_NOT_VALIDATE, (Throwable)ce);
            }
            JpaHelper newJpaHelper = new JpaHelper();
            newJpaHelper.setProject(jpaHelper.getProject());
            newJpaHelper.setValidationFileURIs(jpaHelper.getValidationFileURIs());
            ValidatorLauncher.getLauncher().start((IValidationContext)newJpaHelper, (IValidator)this, reporter);
            return OK_STATUS;
        }
        reporter.removeAllMessages((IValidator)this);
        Iterator<IMessage> stream = jpaProject.validationMessages();
        while (stream.hasNext()) {
            reporter.addMessage((IValidator)this, (IMessage)((Message)stream.next()));
        }
        return OK_STATUS;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }
}

