/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Date;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.jpt.db.internal.DTPTools;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.JavaType;
import org.eclipse.jpt.utility.internal.NameTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Column
extends DTPWrapper
implements Comparable<Column> {
    private final Table table;
    private final org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn;
    private ICatalogObjectListener columnListener;
    private static final JavaType DEFAULT_JAVA_TYPE = new JavaType(Object.class);
    private static final JavaType BLOB_JAVA_TYPE = new JavaType(Blob.class);
    private static final JavaType BYTE_ARRAY_JAVA_TYPE = new JavaType(byte[].class);
    private static final JavaType CLOB_JAVA_TYPE = new JavaType(Clob.class);
    private static final JavaType STRING_JAVA_TYPE = new JavaType(String.class);
    private static final JavaType UTIL_DATE_JAVA_TYPE = new JavaType(Date.class);
    private static final JavaType SQL_DATE_JAVA_TYPE = new JavaType(java.sql.Date.class);
    private static final JavaType SQL_TIME_JAVA_TYPE = new JavaType(Time.class);
    private static final JavaType SQL_TIMESTAMP_JAVA_TYPE = new JavaType(Timestamp.class);
    private static final JavaType BIG_DECIMAL_JAVA_TYPE = new JavaType(BigDecimal.class);
    private static final JavaType LONG_JAVA_TYPE = new JavaType(Long.TYPE);

    Column(Table table, org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        this.table = table;
        this.dtpColumn = dtpColumn;
        this.initialize();
    }

    private void initialize() {
        if (this.connectionIsOnline()) {
            this.columnListener = this.buildColumnListener();
            this.addCatalogObjectListener((ICatalogObject)this.dtpColumn, this.columnListener);
        }
    }

    @Override
    protected boolean connectionIsOnline() {
        return this.table.connectionIsOnline();
    }

    private ICatalogObjectListener buildColumnListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject column, int eventType) {
            }
        };
    }

    @Override
    protected void dispose() {
        this.removeCatalogObjectListener((ICatalogObject)this.dtpColumn, this.columnListener);
    }

    @Override
    public String getName() {
        return this.dtpColumn.getName();
    }

    boolean isCaseSensitive() {
        return this.table.isCaseSensitive();
    }

    public String dataTypeName() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType == null ? null : dataType.getName();
    }

    public String javaFieldName() {
        String jName = this.getName();
        if (!this.isCaseSensitive()) {
            jName = jName.toLowerCase();
        }
        return NameTools.convertToJavaIdentifier((String)jName);
    }

    public boolean matchesJavaFieldName(String javaFieldName) {
        return this.isCaseSensitive() ? this.getName().equals(javaFieldName) : this.getName().equalsIgnoreCase(javaFieldName);
    }

    public String primaryKeyJavaTypeDeclaration() {
        return this.primaryKeyJavaType().declaration();
    }

    public JavaType primaryKeyJavaType() {
        return this.jpaSpecCompliantPrimaryKeyJavaType(this.javaType());
    }

    private JavaType jpaSpecCompliantPrimaryKeyJavaType(JavaType javaType) {
        if (javaType.isVariablePrimitive() || javaType.isVariablePrimitiveWrapper() || javaType.equals(STRING_JAVA_TYPE) || javaType.equals(UTIL_DATE_JAVA_TYPE) || javaType.equals(SQL_DATE_JAVA_TYPE)) {
            return javaType;
        }
        if (javaType.equals(BIG_DECIMAL_JAVA_TYPE)) {
            return LONG_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIME_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIMESTAMP_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        return STRING_JAVA_TYPE;
    }

    public String javaTypeDeclaration() {
        return this.javaType().declaration();
    }

    public JavaType javaType() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof PredefinedDataType ? this.jpaSpecCompliantJavaType(DTPTools.javaTypeFor(((PredefinedDataType)dataType).getPrimitiveType())) : DEFAULT_JAVA_TYPE;
    }

    private JavaType jpaSpecCompliantJavaType(JavaType javaType) {
        if (javaType.equals(BLOB_JAVA_TYPE)) {
            return BYTE_ARRAY_JAVA_TYPE;
        }
        if (javaType.equals(CLOB_JAVA_TYPE)) {
            return STRING_JAVA_TYPE;
        }
        return javaType;
    }

    public boolean isLob() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof PredefinedDataType ? DTPTools.dataTypeIsLob(((PredefinedDataType)dataType).getPrimitiveType()) : false;
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Column column) {
        return this.dtpColumn == column;
    }

    @Override
    public int compareTo(Column column) {
        return Collator.getInstance().compare(this.getName(), column.getName());
    }
}

