/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.details.BaseJpaDetailsPage;
import org.eclipse.jpt.ui.internal.details.IJpaComposite;
import org.eclipse.jpt.ui.internal.java.details.IAttributeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.BasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.DefaultBasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.DefaultEmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EmbeddedIdMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.IdMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.ManyToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.ManyToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.NullAttributeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.OneToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.OneToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.TransientMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.VersionMappingUiProvider;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentAttributeDetailsPage
extends BaseJpaDetailsPage {
    private IPersistentAttribute attribute;
    private IAttributeMapping attributeMapping;
    private Adapter persistentAttributeListener = this.buildAttributeListener();
    private Adapter attributeMappingListener = this.buildAttributeMappingListener();
    private String currentMappingKey;
    private CComboViewer mappingCombo;
    private Map<String, IJpaComposite<IAttributeMapping>> mappingComposites = new HashMap<String, IJpaComposite<IAttributeMapping>>();
    protected PageBook mappingPageBook;
    private IJpaComposite<IAttributeMapping> currentMappingComposite;
    private Collection<IAttributeMappingUiProvider> attributeMappingUiProviders = this.buildAttributeMappingUiProviders();
    private Collection<IAttributeMappingUiProvider> defaultAttributeMappingUiProviders = this.buildDefaultAttributeMappingUiProviders();
    private IAttributeMappingUiProvider nullAttributeMappingUiProvider = this.buildNullAttributeMappingUiProvider();

    public PersistentAttributeDetailsPage(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, (CommandStack)new BasicCommandStack(), widgetFactory);
    }

    protected IAttributeMappingUiProvider buildNullAttributeMappingUiProvider() {
        return NullAttributeMappingUiProvider.instance();
    }

    protected Collection<IAttributeMappingUiProvider> buildAttributeMappingUiProviders() {
        ArrayList<IAttributeMappingUiProvider> providers = new ArrayList<IAttributeMappingUiProvider>();
        providers.add(BasicMappingUiProvider.instance());
        providers.add(EmbeddedMappingUiProvider.instance());
        providers.add(EmbeddedIdMappingUiProvider.instance());
        providers.add(IdMappingUiProvider.instance());
        providers.add(ManyToManyMappingUiProvider.instance());
        providers.add(ManyToOneMappingUiProvider.instance());
        providers.add(OneToManyMappingUiProvider.instance());
        providers.add(OneToOneMappingUiProvider.instance());
        providers.add(TransientMappingUiProvider.instance());
        providers.add(VersionMappingUiProvider.instance());
        return providers;
    }

    protected Collection<IAttributeMappingUiProvider> attributeMappingUiProviders() {
        return this.attributeMappingUiProviders;
    }

    protected Collection<IAttributeMappingUiProvider> buildDefaultAttributeMappingUiProviders() {
        ArrayList<IAttributeMappingUiProvider> providers = new ArrayList<IAttributeMappingUiProvider>();
        providers.add(DefaultBasicMappingUiProvider.instance());
        providers.add(DefaultEmbeddedMappingUiProvider.instance());
        return providers;
    }

    protected Collection<IAttributeMappingUiProvider> defaultAttributeMappingUiProviders() {
        return this.defaultAttributeMappingUiProviders;
    }

    private IAttributeMappingUiProvider attributeMappingUiProvider(String key) {
        for (IAttributeMappingUiProvider provider : this.attributeMappingUiProviders()) {
            if (provider.key() != key) continue;
            return provider;
        }
        return this.nullAttributeMappingUiProvider;
    }

    private IAttributeMappingUiProvider defaultAttributeMappingUiProvider(String key) {
        for (IAttributeMappingUiProvider provider : this.defaultAttributeMappingUiProviders()) {
            if (provider.key() != key) continue;
            return provider;
        }
        return this.nullAttributeMappingUiProvider;
    }

    private Adapter buildAttributeListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PersistentAttributeDetailsPage.this.persistentAttributeChanged(notification);
            }
        };
    }

    void persistentAttributeChanged(Notification notification) {
        switch (notification.getFeatureID(IPersistentAttribute.class)) {
            case 0: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PersistentAttributeDetailsPage.this.populate();
                    }
                });
            }
        }
    }

    private Adapter buildAttributeMappingListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PersistentAttributeDetailsPage.this.attributeMappingChanged(notification);
            }
        };
    }

    void attributeMappingChanged(Notification notification) {
    }

    protected Label buildMappingLabel(Composite parent) {
        return this.getWidgetFactory().createLabel(parent, JptUiMessages.PersistentAttributePage_mapAs);
    }

    protected CComboViewer buildMappingCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        this.mappingCombo = new CComboViewer(combo);
        this.mappingCombo.setContentProvider(this.buildContentProvider());
        this.mappingCombo.setLabelProvider(this.buildLabelProvider());
        this.mappingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PersistentAttributeDetailsPage.this.mappingChanged(event);
            }
        });
        return this.mappingCombo;
    }

    private IContentProvider buildContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                return PersistentAttributeDetailsPage.this.uiProvidersFor((IPersistentAttribute)inputElement);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IAttributeMappingUiProvider[] uiProvidersFor(IPersistentAttribute persistentAttribute) {
        IAttributeMappingUiProvider[] providers = new IAttributeMappingUiProvider[this.attributeMappingUiProviders().size() + 1];
        providers[0] = this.nullAttributeMappingUiProvider;
        for (IAttributeMappingUiProvider uiProvider : this.defaultAttributeMappingUiProviders()) {
            if (uiProvider.key() != persistentAttribute.defaultMappingKey()) continue;
            providers[0] = uiProvider;
            break;
        }
        int i = 1;
        for (IAttributeMappingUiProvider uiProvider : this.attributeMappingUiProviders()) {
            providers[i++] = uiProvider;
        }
        return providers;
    }

    private IBaseLabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((IAttributeMappingUiProvider)element).label();
            }
        };
    }

    protected PageBook buildMappingPageBook(Composite parent) {
        this.mappingPageBook = new PageBook(parent, 0);
        return this.mappingPageBook;
    }

    protected IJpaComposite<IAttributeMapping> buildMappingComposite(PageBook pageBook, String key) {
        if (this.attributeMapping == null || this.attributeMapping.isDefault()) {
            return this.defaultAttributeMappingUiProvider(key).buildAttributeMappingComposite((Composite)pageBook, this.commandStack, this.getWidgetFactory());
        }
        return this.attributeMappingUiProvider(key).buildAttributeMappingComposite((Composite)pageBook, this.commandStack, this.getWidgetFactory());
    }

    void mappingChanged(SelectionChangedEvent event) {
        if (this.isPopulating()) {
            return;
        }
        if (event.getSelection() instanceof StructuredSelection) {
            IAttributeMappingUiProvider provider = (IAttributeMappingUiProvider)((StructuredSelection)event.getSelection()).getFirstElement();
            String key = this.defaultAttributeMappingUiProviders().contains(provider) ? null : provider.key();
            this.attribute.setSpecifiedMappingKey(key);
        }
    }

    @Override
    protected void doPopulate(IJpaContentNode persistentAttributeNode) {
        this.attribute = (IPersistentAttribute)persistentAttributeNode;
        this.populateMappingComboAndPage();
    }

    @Override
    protected void doPopulate() {
        this.populateMappingComboAndPage();
    }

    @Override
    protected void engageListeners() {
        if (this.attribute != null) {
            this.attribute.eAdapters().add((Object)this.persistentAttributeListener);
            if (this.attributeMapping != null) {
                this.attributeMapping.eAdapters().add((Object)this.attributeMappingListener);
            }
        }
    }

    @Override
    protected void disengageListeners() {
        if (this.attribute != null) {
            this.attribute.eAdapters().remove((Object)this.persistentAttributeListener);
            if (this.attributeMapping != null) {
                this.attributeMapping.eAdapters().remove((Object)this.attributeMappingListener);
            }
        }
    }

    private void populateMappingComboAndPage() {
        if (this.attribute == null) {
            this.attributeMapping = null;
            this.currentMappingKey = null;
            this.mappingCombo.setInput(null);
            this.mappingCombo.setSelection((ISelection)StructuredSelection.EMPTY);
            if (this.currentMappingComposite != null) {
                this.currentMappingComposite.populate(null);
                this.currentMappingComposite = null;
            }
            return;
        }
        this.attributeMapping = this.attribute.getMapping();
        this.setComboData(this.attribute.candidateMappingKeys());
        this.populateMappingPage(this.attributeMapping == null ? null : this.attributeMapping.getKey());
    }

    private void populateMappingPage(String mappingKey) {
        if (this.currentMappingComposite != null) {
            if (mappingKey == this.currentMappingKey) {
                if (this.currentMappingComposite != null) {
                    this.currentMappingComposite.populate(this.attributeMapping);
                    return;
                }
            } else {
                this.currentMappingComposite.populate(null);
            }
        }
        this.currentMappingKey = mappingKey;
        IJpaComposite<IAttributeMapping> composite = this.mappingCompositeFor(mappingKey);
        this.mappingPageBook.showPage(composite.getControl());
        this.currentMappingComposite = composite;
        this.currentMappingComposite.populate(this.attributeMapping);
    }

    private void setComboData(Iterator<String> availableMappingKeys) {
        if (this.attribute != this.mappingCombo.getInput()) {
            this.mappingCombo.setInput(this.attribute);
        }
        if (this.attributeMapping == null || this.attributeMapping.isDefault()) {
            this.mappingCombo.setSelection((ISelection)new StructuredSelection(this.mappingCombo.getElementAt(0)));
        } else {
            IAttributeMappingUiProvider provider = this.attributeMappingUiProvider(this.attribute.mappingKey());
            if (provider != null && !provider.equals(((StructuredSelection)this.mappingCombo.getSelection()).getFirstElement())) {
                this.mappingCombo.setSelection((ISelection)new StructuredSelection((Object)provider));
            }
        }
    }

    private IJpaComposite<IAttributeMapping> mappingCompositeFor(String key) {
        IJpaComposite<IAttributeMapping> composite = this.mappingComposites.get(key);
        if (composite != null) {
            return composite;
        }
        composite = this.buildMappingComposite(this.mappingPageBook, key);
        if (composite != null) {
            this.mappingComposites.put(key, composite);
        }
        return composite;
    }

    @Override
    public void dispose() {
        this.disengageListeners();
        Iterator<IJpaComposite<IAttributeMapping>> stream = this.mappingComposites.values().iterator();
        while (stream.hasNext()) {
            stream.next().dispose();
        }
        super.dispose();
    }

    public IPersistentAttribute getAttribute() {
        return this.attribute;
    }
}

