/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.mappings.IMultiRelationshipMapping;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoinTableDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class InverseJoinColumnDialog
extends JoinColumnInJoinTableDialog {
    InverseJoinColumnDialog(Shell parent, IJoinTable joinTable) {
        super(parent, joinTable);
    }

    InverseJoinColumnDialog(Shell parent, IJoinColumn joinColumn) {
        super(parent, joinColumn);
    }

    protected String getTitle() {
        return JptUiMappingsMessages.InverseJoinColumnDialog_editInverseJoinColumn;
    }

    protected void populateNameCombo() {
        Table joinDBTable;
        if (this.getJoinTable() == null) {
            return;
        }
        if (this.getJoinColumn() != null) {
            this.getNameCombo().add(NLS.bind((String)JptUiMappingsMessages.InverseJoinColumnDialog_defaultWithOneParam, (Object)((IJoinColumn)this.getJoinColumn()).getDefaultName()));
        }
        if ((joinDBTable = this.getJoinTable().dbTable()) != null) {
            Iterator i = joinDBTable.columnNames();
            while (i.hasNext()) {
                this.getNameCombo().add((String)i.next());
            }
        }
        if (this.getJoinColumn() != null && ((IJoinColumn)this.getJoinColumn()).getSpecifiedName() != null) {
            this.getNameCombo().setText(((IJoinColumn)this.getJoinColumn()).getSpecifiedName());
        } else {
            this.getNameCombo().select(0);
        }
    }

    protected void populateReferencedNameCombo() {
        Table referencedDbTable;
        IMultiRelationshipMapping multiRelationshipMapping;
        IEntity targetEntity;
        if (this.getJoinTable() == null) {
            return;
        }
        if (this.getJoinColumn() != null) {
            this.getReferencedColumnNameCombo().add(NLS.bind((String)JptUiMappingsMessages.InverseJoinColumnDialog_defaultWithOneParam, (Object)((IJoinColumn)this.getJoinColumn()).getDefaultReferencedColumnName()));
        }
        if ((targetEntity = (multiRelationshipMapping = (IMultiRelationshipMapping)this.getJoinTable().eContainer()).getResolvedTargetEntity()) != null && (referencedDbTable = targetEntity.primaryDbTable()) != null) {
            Iterator i = referencedDbTable.columnNames();
            while (i.hasNext()) {
                this.getReferencedColumnNameCombo().add((String)i.next());
            }
        }
        if (this.getJoinColumn() != null && ((IJoinColumn)this.getJoinColumn()).getSpecifiedReferencedColumnName() != null) {
            this.getReferencedColumnNameCombo().setText(((IJoinColumn)this.getJoinColumn()).getSpecifiedReferencedColumnName());
        } else {
            this.getReferencedColumnNameCombo().select(0);
        }
    }
}

