/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.IBasic;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class LobCheckBox
extends BaseJpaController {
    private IBasic basicMapping;
    private Adapter basicMappingListener;
    private Button button;

    public LobCheckBox(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildBasicMappingListener();
    }

    private void buildBasicMappingListener() {
        this.basicMappingListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                LobCheckBox.this.bsaicMappingChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.BasicGeneralSection_lobLabel, 32);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                LobCheckBox.this.lobSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LobCheckBox.this.lobSelectionChanged();
            }
        });
    }

    void lobSelectionChanged() {
        boolean lob = this.button.getSelection();
        if (this.basicMapping.isLob() != lob) {
            this.basicMapping.setLob(lob);
        }
    }

    private void bsaicMappingChanged(Notification notification) {
        if (notification.getFeatureID(IBasic.class) == 3) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LobCheckBox.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.basicMapping != null) {
            this.basicMapping.eAdapters().add((Object)this.basicMappingListener);
        }
    }

    protected void disengageListeners() {
        if (this.basicMapping != null) {
            this.basicMapping.eAdapters().remove((Object)this.basicMappingListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.basicMapping = (IBasic)obj;
        this.populateButton();
    }

    protected void doPopulate() {
        this.populateButton();
    }

    private void populateButton() {
        boolean lob = false;
        if (this.basicMapping != null) {
            lob = this.basicMapping.isLob();
        }
        if (this.button.getSelection() != lob) {
            this.button.setSelection(lob);
        }
    }

    public Control getControl() {
        return this.button;
    }
}

