/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SecondaryTableDialog
extends Dialog {
    private ISecondaryTable secondaryTable;
    private IEntity entity;
    protected Combo nameCombo;
    protected Combo catalogCombo;
    protected Combo schemaCombo;
    private String selectedName;
    private String selectedSchema;
    private String selectedCatalog;
    private boolean defaultSchemaSelected;
    private boolean defaultCatalogSelected;

    SecondaryTableDialog(Shell parent, IEntity entity) {
        super(parent);
        this.entity = entity;
    }

    SecondaryTableDialog(Shell parent, ISecondaryTable secondaryTable, IEntity entity) {
        super(parent);
        this.secondaryTable = secondaryTable;
        this.entity = entity;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return JptUiMappingsMessages.SecondaryTableDialog_editSecondaryTable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(JptUiMappingsMessages.SecondaryTableDialog_name);
        GridData gridData = new GridData();
        nameLabel.setLayoutData((Object)gridData);
        this.nameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameCombo.setLayoutData((Object)gridData);
        this.populateNameCombo();
        Label catalogLabel = new Label(composite, 16384);
        catalogLabel.setText(JptUiMappingsMessages.SecondaryTableDialog_catalog);
        gridData = new GridData();
        catalogLabel.setLayoutData((Object)gridData);
        this.catalogCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.catalogCombo.setLayoutData((Object)gridData);
        this.populateCatalogCombo();
        Label schemaLabel = new Label(composite, 16384);
        schemaLabel.setText(JptUiMappingsMessages.SecondaryTableDialog_schema);
        gridData = new GridData();
        schemaLabel.setLayoutData((Object)gridData);
        this.schemaCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.schemaCombo.setLayoutData((Object)gridData);
        this.populateSchemaCombo();
        return composite;
    }

    protected Database getDatabase() {
        return this.getConnectionProfile().getDatabase();
    }

    private ConnectionProfile getConnectionProfile() {
        IJpaProject project = this.secondaryTable == null ? this.entity.getJpaProject() : this.secondaryTable.getJpaProject();
        return project.connectionProfile();
    }

    protected Schema getTableSchema() {
        Database database = this.getDatabase();
        if (database != null) {
            if (this.secondaryTable != null) {
                return database.schemaNamed(this.secondaryTable.getSchema());
            }
            return database.schemaNamed(this.entity.getTable().getSchema());
        }
        return null;
    }

    protected void populateNameCombo() {
        Schema schema = this.getTableSchema();
        if (schema != null) {
            Iterator tables = schema.tableNames();
            Iterator stream = CollectionTools.sort((Iterator)tables);
            while (stream.hasNext()) {
                this.nameCombo.add((String)stream.next());
            }
        }
        if (this.getSecondaryTable() != null && this.getSecondaryTable().getSpecifiedName() != null) {
            this.nameCombo.setText(this.getSecondaryTable().getSpecifiedName());
        }
    }

    protected void populateSchemaCombo() {
        Database database;
        if (this.getSecondaryTable() != null) {
            this.schemaCombo.add(NLS.bind((String)JptUiMappingsMessages.SecondaryTableDialog_defaultSchema, (Object)this.getSecondaryTable().getDefaultSchema()));
        }
        if ((database = this.getDatabase()) != null) {
            Iterator schemata = database.schemaNames();
            Iterator stream = CollectionTools.sort((Iterator)schemata);
            while (stream.hasNext()) {
                this.schemaCombo.add((String)stream.next());
            }
        }
        if (this.getSecondaryTable() != null) {
            if (this.getSecondaryTable().getSpecifiedSchema() != null) {
                this.schemaCombo.setText(this.getSecondaryTable().getSpecifiedSchema());
            } else {
                this.schemaCombo.select(0);
            }
        }
    }

    protected void populateCatalogCombo() {
        Database database;
        if (this.getSecondaryTable() != null) {
            this.catalogCombo.add(NLS.bind((String)JptUiMappingsMessages.SecondaryTableDialog_defaultCatalog, (Object)this.getSecondaryTable().getDefaultCatalog()));
        }
        if ((database = this.getDatabase()) != null) {
            Iterator catalogs = database.catalogNames();
            Iterator stream = CollectionTools.sort((Iterator)catalogs);
            while (stream.hasNext()) {
                this.catalogCombo.add((String)stream.next());
            }
        }
        if (this.getSecondaryTable() != null) {
            if (this.getSecondaryTable().getSpecifiedCatalog() != null) {
                this.catalogCombo.setText(this.getSecondaryTable().getSpecifiedCatalog());
            } else {
                this.catalogCombo.select(0);
            }
        }
    }

    protected Combo getNameCombo() {
        return this.nameCombo;
    }

    protected Combo getSchemaCombo() {
        return this.schemaCombo;
    }

    protected Combo getCatalogCombo() {
        return this.catalogCombo;
    }

    protected ISecondaryTable getSecondaryTable() {
        return this.secondaryTable;
    }

    protected String getSelectedName() {
        return this.selectedName;
    }

    protected String getSelectedCatalog() {
        return this.selectedCatalog;
    }

    protected String getSelectedSchema() {
        return this.selectedSchema;
    }

    protected boolean isDefaultSchemaSelected() {
        return this.defaultSchemaSelected;
    }

    protected boolean isDefaultCatalogSelected() {
        return this.defaultCatalogSelected;
    }

    public boolean close() {
        this.selectedName = this.nameCombo.getText();
        this.selectedSchema = this.schemaCombo.getText();
        if (this.selectedSchema.equals("")) {
            this.selectedSchema = null;
        }
        this.selectedCatalog = this.catalogCombo.getText();
        if (this.selectedCatalog.equals("")) {
            this.selectedCatalog = null;
        }
        this.defaultSchemaSelected = this.schemaCombo.getSelectionIndex() == 0;
        this.defaultCatalogSelected = this.catalogCombo.getSelectionIndex() == 0;
        return super.close();
    }
}

