/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.mappings.IId;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.GeneratorComposite;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableGeneratorComposite
extends GeneratorComposite<ITableGenerator> {
    private CCombo tableNameCombo;
    private CCombo pkColumnNameCombo;
    private CCombo valueColumnNameCombo;
    private CCombo pkColumnValueCombo;
    private ConnectionListener connectionListener = this.buildConnectionListener();
    private ConnectionProfile connectionProfile;

    public TableGeneratorComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, commandStack, widgetFactory);
    }

    @Override
    protected ITableGenerator createGenerator() {
        ITableGenerator tableGenerator = this.idMapping().createTableGenerator();
        this.idMapping().setTableGenerator(tableGenerator);
        return tableGenerator;
    }

    @Override
    protected ITableGenerator generator(IId idMapping) {
        return idMapping.getTableGenerator();
    }

    @Override
    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.TableGeneratorComposite_name);
        this.nameTextWidget = this.buildNameText(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameTextWidget.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.nameTextWidget, "org.eclipse.jpt.ui.mapping_tableGeneratorName");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.TableGeneratorComposite_table);
        this.tableNameCombo = this.buildTableNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableNameCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.tableNameCombo, "org.eclipse.jpt.ui.mapping_tableGeneratorTable");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.TableGeneratorComposite_pkColumn);
        this.pkColumnNameCombo = this.buildPkColumnNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.pkColumnNameCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.pkColumnNameCombo, "org.eclipse.jpt.ui.mapping_tableGeneratorPrimaryKeyColumn");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.TableGeneratorComposite_valueColumn);
        this.valueColumnNameCombo = this.buildValueColumnNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.valueColumnNameCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.valueColumnNameCombo, "org.eclipse.jpt.ui.mapping_tableGeneratorValueColumn");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.TableGeneratorComposite_pkColumnValue);
        this.pkColumnValueCombo = this.buildPkColumnValueCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.pkColumnValueCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.pkColumnValueCombo, "org.eclipse.jpt.ui.mapping_tableGeneratorPrimaryKeyColumnValue");
    }

    private CCombo buildTableNameCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildTableNameListener());
        return combo;
    }

    private CCombo buildPkColumnNameCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildPkColumnNameListener());
        return combo;
    }

    private CCombo buildValueColumnNameCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildValueColumnNameListener());
        return combo;
    }

    private CCombo buildPkColumnValueCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildPkColumnValueListener());
        return combo;
    }

    private ModifyListener buildTableNameListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ITableGenerator generator;
                if (TableGeneratorComposite.this.isPopulating()) {
                    return;
                }
                String text = ((CCombo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.tableNameCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.tableNameCombo.getItem(0))) {
                    text = null;
                }
                if ((generator = (ITableGenerator)TableGeneratorComposite.this.getGenerator()) == null) {
                    generator = TableGeneratorComposite.this.createGenerator();
                }
                generator.setSpecifiedTable(text);
            }
        };
    }

    private ModifyListener buildPkColumnNameListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ITableGenerator generator;
                if (TableGeneratorComposite.this.isPopulating()) {
                    return;
                }
                String text = ((CCombo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.pkColumnNameCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.pkColumnNameCombo.getItem(0))) {
                    text = null;
                }
                if ((generator = (ITableGenerator)TableGeneratorComposite.this.getGenerator()) == null) {
                    generator = TableGeneratorComposite.this.createGenerator();
                }
                generator.setSpecifiedPkColumnName(text);
            }
        };
    }

    private ModifyListener buildValueColumnNameListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ITableGenerator generator;
                if (TableGeneratorComposite.this.isPopulating()) {
                    return;
                }
                String text = ((CCombo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.valueColumnNameCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.valueColumnNameCombo.getItem(0))) {
                    text = null;
                }
                if ((generator = (ITableGenerator)TableGeneratorComposite.this.getGenerator()) == null) {
                    generator = TableGeneratorComposite.this.createGenerator();
                }
                generator.setSpecifiedValueColumnName(text);
            }
        };
    }

    private ModifyListener buildPkColumnValueListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ITableGenerator generator;
                if (TableGeneratorComposite.this.isPopulating()) {
                    return;
                }
                String text = ((CCombo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.pkColumnValueCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.pkColumnValueCombo.getItem(0))) {
                    text = null;
                }
                if ((generator = (ITableGenerator)TableGeneratorComposite.this.getGenerator()) == null) {
                    generator = TableGeneratorComposite.this.createGenerator();
                }
                generator.setSpecifiedPkColumnValue(text);
            }
        };
    }

    @Override
    protected void generatorChanged(Notification notification) {
        super.generatorChanged(notification);
        if (notification.getFeatureID(ITableGenerator.class) == 8) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableGeneratorComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    String tableName = ((ITableGenerator)TableGeneratorComposite.this.getGenerator()).getSpecifiedTable();
                    if (tableName == null) {
                        TableGeneratorComposite.this.tableNameCombo.select(0);
                    } else if (!TableGeneratorComposite.this.tableNameCombo.getText().equals(tableName)) {
                        TableGeneratorComposite.this.tableNameCombo.setText(tableName);
                    }
                    TableGeneratorComposite.this.populatePkColumnNameCombo();
                    TableGeneratorComposite.this.populateValueColumnNameCombo();
                }
            });
        } else if (notification.getFeatureID(ITableGenerator.class) == 17) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableGeneratorComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    TableGeneratorComposite.this.populatePkColumnName();
                }
            });
        } else if (notification.getFeatureID(ITableGenerator.class) == 20) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableGeneratorComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    String columnName = ((ITableGenerator)TableGeneratorComposite.this.getGenerator()).getSpecifiedValueColumnName();
                    if (columnName == null) {
                        TableGeneratorComposite.this.valueColumnNameCombo.select(0);
                    } else if (!TableGeneratorComposite.this.valueColumnNameCombo.getText().equals(columnName)) {
                        TableGeneratorComposite.this.valueColumnNameCombo.setText(columnName);
                    }
                }
            });
        } else if (notification.getFeatureID(ITableGenerator.class) == 23) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableGeneratorComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    String columnValue = ((ITableGenerator)TableGeneratorComposite.this.getGenerator()).getSpecifiedPkColumnValue();
                    if (columnValue == null) {
                        TableGeneratorComposite.this.pkColumnValueCombo.select(0);
                    } else if (!TableGeneratorComposite.this.pkColumnValueCombo.getText().equals(columnValue)) {
                        TableGeneratorComposite.this.pkColumnValueCombo.setText(columnValue);
                    }
                }
            });
        }
    }

    @Override
    protected void doPopulate(EObject obj) {
        super.doPopulate(obj);
        if (obj == null) {
            this.connectionProfile = null;
            return;
        }
        this.populateTableNameCombo();
        this.populatePkColumnNameCombo();
        this.populateValueColumnNameCombo();
        this.populatePkColumnValueCombo();
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateTableNameCombo();
        this.populatePkColumnNameCombo();
        this.populateValueColumnNameCombo();
        this.populatePkColumnValueCombo();
    }

    @Override
    protected void engageListeners() {
        super.engageListeners();
        if (this.getGenerator() != null) {
            this.addConnectionListener();
        }
    }

    @Override
    protected void disengageListeners() {
        if (this.getGenerator() != null) {
            this.removeConnectionListener();
        }
        super.disengageListeners();
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            IJpaProject jpaProject = this.idMapping().getJpaProject();
            this.connectionProfile = jpaProject.connectionProfile();
        }
        return this.connectionProfile;
    }

    private void addConnectionListener() {
        this.getConnectionProfile().addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.getConnectionProfile().removeConnectionListener(this.connectionListener);
    }

    protected Schema getSchema() {
        if (this.getGenerator() != null) {
            return this.getConnectionProfile().getDatabase().schemaNamed(((ITableGenerator)this.getGenerator()).getSchema());
        }
        return null;
    }

    private void populateTableNameCombo() {
        String tableName;
        if (this.getGenerator() == null) {
            return;
        }
        if (this.getConnectionProfile().isConnected()) {
            this.tableNameCombo.remove(1, this.tableNameCombo.getItemCount() - 1);
            Schema schema = this.getSchema();
            if (schema != null) {
                Iterator tables = schema.tableNames();
                Iterator stream = CollectionTools.sort((Iterator)tables);
                while (stream.hasNext()) {
                    this.tableNameCombo.add((String)stream.next());
                }
            }
        }
        if ((tableName = ((ITableGenerator)this.getGenerator()).getSpecifiedTable()) != null) {
            if (!this.tableNameCombo.getText().equals(tableName)) {
                this.tableNameCombo.setText(tableName);
            }
        } else {
            this.tableNameCombo.select(0);
        }
    }

    private void populatePkColumnNameCombo() {
        if (this.getGenerator() == null) {
            return;
        }
        this.populatePkColumnChoices();
        this.populatePkColumnName();
    }

    private void populatePkColumnChoices() {
        this.pkColumnNameCombo.remove(1, this.pkColumnNameCombo.getItemCount() - 1);
        if (this.getConnectionProfile().isConnected() && !this.tableNameCombo.getText().equals(JptUiMappingsMessages.TableGeneratorComposite_default)) {
            Table table;
            String tableName = this.tableNameCombo.getText();
            Schema schema = this.getSchema();
            if (schema != null && (table = schema.tableNamed(tableName)) != null) {
                Iterator stream = CollectionTools.sort((Iterator)table.columnNames());
                while (stream.hasNext()) {
                    this.pkColumnNameCombo.add((String)stream.next());
                }
            }
        }
    }

    private void populatePkColumnName() {
        String pkColumnName = ((ITableGenerator)this.getGenerator()).getSpecifiedPkColumnName();
        if (pkColumnName != null) {
            if (!this.pkColumnNameCombo.getText().equals(pkColumnName)) {
                this.pkColumnNameCombo.setText(pkColumnName);
            }
        } else {
            this.pkColumnNameCombo.select(0);
        }
    }

    private void populateValueColumnNameCombo() {
        String valueColumnName;
        if (this.getGenerator() == null) {
            return;
        }
        if (this.getConnectionProfile().isConnected()) {
            this.valueColumnNameCombo.remove(1, this.valueColumnNameCombo.getItemCount() - 1);
            if (!this.tableNameCombo.getText().equals(JptUiMappingsMessages.TableGeneratorComposite_default)) {
                Table table;
                String tableName = this.tableNameCombo.getText();
                Schema schema = this.getSchema();
                if (schema != null && (table = schema.tableNamed(tableName)) != null) {
                    Iterator stream = CollectionTools.sort((Iterator)table.columnNames());
                    while (stream.hasNext()) {
                        this.valueColumnNameCombo.add((String)stream.next());
                    }
                }
            }
        }
        if ((valueColumnName = ((ITableGenerator)this.getGenerator()).getSpecifiedValueColumnName()) != null) {
            if (!this.valueColumnNameCombo.getText().equals(valueColumnName)) {
                this.valueColumnNameCombo.setText(valueColumnName);
            }
        } else {
            this.valueColumnNameCombo.select(0);
        }
    }

    private void populatePkColumnValueCombo() {
        if (this.getGenerator() == null) {
            return;
        }
        String pkColumnValue = ((ITableGenerator)this.getGenerator()).getSpecifiedPkColumnValue();
        if (pkColumnValue != null) {
            if (!this.pkColumnValueCombo.getText().equals(pkColumnValue)) {
                this.pkColumnValueCombo.setText(pkColumnValue);
            }
        } else {
            this.pkColumnValueCombo.select(0);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.tableNameCombo.select(0);
        this.pkColumnNameCombo.select(0);
        this.pkColumnValueCombo.select(0);
        this.valueColumnNameCombo.select(0);
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void closed(Connection connection) {
                this.populate();
            }

            public void modified(Connection connection) {
                this.populate();
            }

            public void opened(Connection connection) {
                this.populate();
            }

            public void databaseChanged(Connection connection, Database database) {
                this.populate();
            }

            public void schemaChanged(Connection connection, Schema schema) {
                this.populate();
            }

            private void populate() {
                TableGeneratorComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (TableGeneratorComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        TableGeneratorComposite.this.populateTableNameCombo();
                        TableGeneratorComposite.this.populatePkColumnChoices();
                        TableGeneratorComposite.this.populateValueColumnNameCombo();
                    }
                });
            }

            public void aboutToClose(Connection connection) {
            }

            public boolean okToClose(Connection connection) {
                return true;
            }

            public void tableChanged(Connection connection, Table table) {
            }
        };
    }
}

