/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.selection;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.ui.internal.selection.AbstractSelectionParticipant;
import org.eclipse.jpt.ui.internal.selection.ISelectionManager;
import org.eclipse.jpt.ui.internal.selection.Selection;
import org.eclipse.jpt.ui.internal.selection.SelectionEvent;
import org.eclipse.jpt.ui.internal.views.AbstractJpaView;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorSelectionParticipant
extends AbstractSelectionParticipant {
    private ITextEditor editor;
    private IPropertyListener editorInputListener;
    private ISelectionChangedListener editorSelectionListener;
    private Selection currentSelection;
    private boolean suppressNotification = false;

    public TextEditorSelectionParticipant(ISelectionManager theSelectionManager, ITextEditor theEditor) {
        super(theSelectionManager);
        this.editor = theEditor;
        this.editorInputListener = new EditorInputListener();
        this.editor.addPropertyListener(this.editorInputListener);
        this.editorSelectionListener = new EditorSelectionListener();
        if (this.editor.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.editor.getSelectionProvider()).addPostSelectionChangedListener(this.editorSelectionListener);
        }
        this.currentSelection = this.calculateSelection();
    }

    private void editorInputChanged() {
        Selection newSelection = this.calculateSelection();
        if (!newSelection.equals(this.currentSelection)) {
            this.currentSelection = newSelection;
            if (!this.suppressNotification) {
                this.selectionManager.select(newSelection);
            }
        }
    }

    private void editorSelectionChanged(SelectionChangedEvent event) {
        Selection newSelection = this.calculateSelection();
        if (!newSelection.equals(this.currentSelection)) {
            this.currentSelection = newSelection;
            if (this.editor.getEditorSite().getPage().getActivePart() instanceof AbstractJpaView) {
                return;
            }
            if (!this.suppressNotification) {
                this.selectionManager.select(newSelection);
            }
        }
    }

    private Selection calculateSelection() {
        if (this.editor == null) {
            return Selection.NULL_SELECTION;
        }
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        IJpaFile persistenceFile = this.persistenceFileFor(this.editor.getEditorInput());
        if (persistenceFile == null || !(selection instanceof ITextSelection)) {
            return Selection.NULL_SELECTION;
        }
        IJpaContentNode selectedNode = persistenceFile.getContentNode(((ITextSelection)selection).getOffset());
        if (selectedNode == null) {
            return Selection.NULL_SELECTION;
        }
        return new Selection(selectedNode);
    }

    public Selection getSelection() {
        return this.currentSelection;
    }

    public IJpaFile persistenceFileFor(IEditorInput input) {
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            file = fileInput.getFile();
        }
        if (file == null) {
            return null;
        }
        return JptCorePlugin.getJpaFile(file);
    }

    public void selectionChanged(SelectionEvent evt) {
        Selection newSelection = evt.getSelection();
        if (this.getSelection().equals(newSelection) || newSelection == Selection.NULL_SELECTION) {
            return;
        }
        this.suppressNotification = true;
        IJpaContentNode selectedNode = newSelection.getSelectedNode();
        ITextRange textRange = selectedNode.selectionTextRange();
        if (textRange != null) {
            this.editor.selectAndReveal(textRange.getOffset(), textRange.getLength());
        }
        this.suppressNotification = false;
    }

    public boolean disposeOnHide() {
        return true;
    }

    public void dispose() {
        this.editor.removePropertyListener(this.editorInputListener);
        if (this.editor.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.editor.getSelectionProvider()).removePostSelectionChangedListener(this.editorSelectionListener);
        }
    }

    private class EditorInputListener
    implements IPropertyListener {
        private EditorInputListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (TextEditorSelectionParticipant.this.editor == source && propId == 258) {
                TextEditorSelectionParticipant.this.editorInputChanged();
            }
        }
    }

    private class EditorSelectionListener
    implements ISelectionChangedListener {
        private EditorSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TextEditorSelectionParticipant.this.editorSelectionChanged(event);
        }
    }
}

