/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentType;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.ui.internal.JptUiPlugin;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.xml.JptUiXmlMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlJavaClassChooser
extends BaseJpaController {
    private XmlPersistentType persistentType;
    private Adapter persistentTypeListener;
    private Composite composite;
    private Text text;
    private JavaTypeCompletionProcessor javaTypeCompletionProcessor;

    public XmlJavaClassChooser(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildPersistentTypeListener();
    }

    private void buildPersistentTypeListener() {
        this.persistentTypeListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                XmlJavaClassChooser.this.persistentTypeChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 1;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        this.text = this.getWidgetFactory().createText(this.composite, "");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlJavaClassChooser.this.textModified(e);
            }
        });
        this.javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        ControlContentAssistHelper.createTextContentAssistant((Text)this.text, (IContentAssistProcessor)this.javaTypeCompletionProcessor);
        Button browseButton = this.getWidgetFactory().createButton(this.composite, "Browse...", 0x800000);
        data = new GridData();
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IType type = XmlJavaClassChooser.this.chooseType();
                if (type != null) {
                    XmlJavaClassChooser.this.text.setText(type.getFullyQualifiedName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IType type = XmlJavaClassChooser.this.chooseType();
                if (type != null) {
                    XmlJavaClassChooser.this.text.setText(type.getFullyQualifiedName());
                }
            }
        });
    }

    private void textModified(ModifyEvent e) {
        if (this.isPopulating()) {
            return;
        }
        String text = ((Text)e.getSource()).getText();
        this.persistentType.setClass(text);
    }

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.text.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)this.getType());
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            throw new RuntimeException(e);
        }
        typeSelectionDialog.setTitle(JptUiXmlMessages.XmlJavaClassChooser_XmlJavaClassDialog_title);
        typeSelectionDialog.setMessage(JptUiXmlMessages.XmlJavaClassChooser_XmlJavaClassDialog_message);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private String getType() {
        return this.text.getText();
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        IProject project = this.persistentType.getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
    }

    private void persistentTypeChanged(Notification notification) {
        if (notification.getFeatureID(XmlPersistentType.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    XmlJavaClassChooser.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.persistentType != null) {
            this.persistentType.eAdapters().add((Object)this.persistentTypeListener);
        }
    }

    protected void disengageListeners() {
        if (this.persistentType != null) {
            this.persistentType.eAdapters().remove((Object)this.persistentTypeListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.persistentType = obj == null ? null : ((XmlTypeMapping)obj).getPersistentType();
        this.populateText();
    }

    protected void doPopulate() {
        this.populateText();
    }

    private void populateText() {
        String javaClass;
        if (this.persistentType == null) {
            this.text.clearSelection();
            return;
        }
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            this.javaTypeCompletionProcessor.setPackageFragment(root.getPackageFragment(""));
        }
        if ((javaClass = this.persistentType.getClass_()) == null) {
            this.setTextData("");
        } else {
            this.setTextData(javaClass);
        }
    }

    private void setTextData(String textData) {
        if (!textData.equals(this.text.getText())) {
            this.text.setText(textData);
        }
    }

    public Control getControl() {
        return this.composite;
    }
}

