/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterators;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.iterators.IteratorEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorEnumerationTests
extends TestCase {
    public IteratorEnumerationTests(String name) {
        super(name);
    }

    public void testHasMoreElements() {
        int i = 0;
        Enumeration<String> stream = this.buildEnumeration();
        while (stream.hasMoreElements()) {
            stream.nextElement();
            ++i;
        }
        IteratorEnumerationTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testHasMoreElementsUpcast() {
        int i = 0;
        Enumeration<Object> stream = this.buildEnumerationUpcast();
        while (stream.hasMoreElements()) {
            stream.nextElement();
            ++i;
        }
        IteratorEnumerationTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testNextElement() {
        Iterator<String> iterator = this.buildIterator();
        Enumeration<String> stream = this.buildEnumeration();
        while (stream.hasMoreElements()) {
            IteratorEnumerationTests.assertEquals((String)"bogus element", (String)iterator.next(), (String)stream.nextElement());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Enumeration<String> stream = this.buildEnumeration();
        String string = null;
        while (stream.hasMoreElements()) {
            string = stream.nextElement();
        }
        try {
            string = stream.nextElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IteratorEnumerationTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    private Enumeration<String> buildEnumeration() {
        return this.buildEnumeration(this.buildIterator());
    }

    private Enumeration<Object> buildEnumerationUpcast() {
        return this.buildEnumerationUpcast(this.buildIterator());
    }

    private Enumeration<String> buildEnumeration(Iterator<String> iterator) {
        return new IteratorEnumeration(iterator);
    }

    private Enumeration<Object> buildEnumerationUpcast(Iterator<String> iterator) {
        return new IteratorEnumeration(iterator);
    }

    private Iterator<String> buildIterator() {
        return this.buildVector().iterator();
    }

    private Vector<String> buildVector() {
        Vector<String> v = new Vector<String>();
        v.addElement("one");
        v.addElement("two");
        v.addElement("three");
        v.addElement("four");
        v.addElement("five");
        v.addElement("six");
        v.addElement("seven");
        v.addElement("eight");
        return v;
    }
}

