/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.Collator;
import org.eclipse.jpt.utility.internal.ClassTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaType
implements Comparable<JavaType>,
Cloneable,
Serializable {
    private final String elementTypeName;
    private final int arrayDepth;
    private static final long serialVersionUID = 1L;

    public JavaType(String elementTypeName, int arrayDepth) {
        if (elementTypeName == null || elementTypeName.length() == 0) {
            throw new IllegalArgumentException("The element type name is required.");
        }
        if (ClassTools.arrayDepthForClassNamed(elementTypeName) != 0) {
            throw new IllegalArgumentException("The element type must not be an array: " + elementTypeName + '.');
        }
        if (arrayDepth < 0) {
            throw new IllegalArgumentException("The array depth must be greater than or equal to zero: " + arrayDepth + '.');
        }
        if (elementTypeName.equals(Void.TYPE.getName()) && arrayDepth != 0) {
            throw new IllegalArgumentException("'void' must have an array depth of zero: " + arrayDepth + '.');
        }
        this.elementTypeName = elementTypeName;
        this.arrayDepth = arrayDepth;
    }

    public JavaType(String javaClassName) {
        this(ClassTools.elementTypeNameForClassNamed(javaClassName), ClassTools.arrayDepthForClassNamed(javaClassName));
    }

    public JavaType(Class<?> javaClass) {
        this(javaClass.getName());
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    public boolean isPrimitive() {
        return this.arrayDepth == 0 && ClassTools.classNamedIsPrimitive(this.elementTypeName);
    }

    public boolean isPrimitiveWrapper() {
        return this.arrayDepth == 0 && ClassTools.classNamedIsPrimitiveWrapperClass(this.elementTypeName);
    }

    public boolean isVariablePrimitive() {
        return this.arrayDepth == 0 && ClassTools.classNamedIsVariablePrimitive(this.elementTypeName);
    }

    public boolean isVariablePrimitiveWrapper() {
        return this.arrayDepth == 0 && ClassTools.classNamedIsVariablePrimitiveWrapperClass(this.elementTypeName);
    }

    public Class<?> javaClass() throws ClassNotFoundException {
        return ClassTools.classForTypeDeclaration(this.elementTypeName, this.arrayDepth);
    }

    public String javaClassName() {
        return ClassTools.classNameForTypeDeclaration(this.elementTypeName, this.arrayDepth);
    }

    public boolean equals(String otherElementTypeName, int otherArrayDepth) {
        return this.arrayDepth == otherArrayDepth && this.elementTypeName.equals(otherElementTypeName);
    }

    public boolean describes(String className) {
        return this.equals(ClassTools.elementTypeNameForClassNamed(className), ClassTools.arrayDepthForClassNamed(className));
    }

    public boolean describes(Class<?> javaClass) {
        return this.describes(javaClass.getName());
    }

    public boolean equals(JavaType other) {
        return this.equals(other.elementTypeName, other.arrayDepth);
    }

    public boolean equals(Object o) {
        return o instanceof JavaType ? this.equals((JavaType)o) : false;
    }

    public int hashCode() {
        return this.elementTypeName.hashCode() ^ this.arrayDepth;
    }

    @Override
    public int compareTo(JavaType jt) {
        int x = Collator.getInstance().compare(this.elementTypeName, jt.elementTypeName);
        return x != 0 ? x : this.arrayDepth - jt.arrayDepth;
    }

    public String declaration() {
        if (this.arrayDepth == 0) {
            return this.elementTypeNameDeclaration();
        }
        StringBuffer sb = new StringBuffer(this.elementTypeName.length() + 2 * this.arrayDepth);
        this.appendDeclarationTo(sb);
        return sb.toString();
    }

    public void appendDeclarationTo(StringBuffer sb) {
        sb.append(this.elementTypeNameDeclaration());
        int i = this.arrayDepth;
        while (i-- > 0) {
            sb.append("[]");
        }
    }

    public void printDeclarationOn(PrintWriter pw) {
        pw.print(this.elementTypeNameDeclaration());
        int i = this.arrayDepth;
        while (i-- > 0) {
            pw.print("[]");
        }
    }

    private String elementTypeNameDeclaration() {
        return this.elementTypeName.replace('$', '.');
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassTools.shortClassNameForObject(this));
        sb.append('(');
        this.appendDeclarationTo(sb);
        sb.append(')');
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

