/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.EntityGroup;
import org.eclipse.jst.jsf.common.metadata.query.AbstractEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleResultSet;

public class SimpleEntityQueryVisitorImpl
extends AbstractEntityQueryVisitor {
    private HierarchicalSearchControl control;
    private boolean _stop;
    private EntityQueryComparator entityComparator;
    private List _entityResults;

    public SimpleEntityQueryVisitorImpl() {
        this.control = new HierarchicalSearchControl();
    }

    public SimpleEntityQueryVisitorImpl(HierarchicalSearchControl control) {
        this.control = control;
    }

    public IResultSet findEntities(Entity initialEntityContext, String entityKey) {
        this.resetQuery();
        if (initialEntityContext != null) {
            this.entityComparator = new EntityQueryComparator(entityKey);
            initialEntityContext.accept(this);
        }
        return new SimpleResultSet(this.getInternalEntityResults());
    }

    private void resetQuery() {
        this._stop = false;
        this._entityResults = null;
    }

    private List getInternalEntityResults() {
        if (this._entityResults == null) {
            this._entityResults = new ArrayList();
        }
        return this._entityResults;
    }

    public void visit(Entity key) {
        switch (this.entityComparator.compareTo(key)) {
            case 0: {
                this.getInternalEntityResults().add(key);
                break;
            }
        }
        this.checkShouldStopVisitingEntities();
    }

    public void visitCompleted(Entity entity) {
        this.entityComparator.popContext();
    }

    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisitingEntities() {
        if (this.control.getCountLimit() == this.getInternalEntityResults().size() && this.control.getCountLimit() != -1) {
            this._stop = true;
        }
    }

    private class EntityQueryComparator
    implements Comparable {
        private String entityKey;
        private EntityStack stack;

        public EntityQueryComparator(String entityKey) {
            this.entityKey = entityKey;
            this.stack = new EntityStack();
        }

        public int compareTo(Object entity) {
            this.stack.push(entity);
            return this.entityKey.compareTo(this.getRelativeId());
        }

        public void popContext() {
            this.stack.pop();
        }

        private String getRelativeId() {
            int size = this.stack.size();
            int i = 1;
            StringBuffer buf = new StringBuffer();
            while (i < size) {
                Entity e = (Entity)this.stack.elementAt(i);
                if (!(e instanceof EntityGroup)) {
                    if (buf.length() > 0) {
                        buf.append("/");
                    }
                    buf.append(e.getId());
                }
                ++i;
            }
            return buf.toString();
        }
    }

    private class EntityStack
    extends Stack {
        private static final long serialVersionUID = -6010267544968175003L;
    }
}

