/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.tests;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.provider.IContentProposalProvider;
import org.eclipse.jst.jsf.context.symbol.provider.ProposalCreationFactoryAdapter;
import org.eclipse.jst.jsf.context.symbol.tests.ContextSymbolTestPlugin;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.swt.graphics.Image;

public class TestIPropertySymbolItemProvider
extends TestCase {
    private Properties props;

    protected void setUp() throws Exception {
        super.setUp();
        TestFileResource propertiesFile = new TestFileResource();
        propertiesFile.load(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/bundle.properties.data");
        this.props = new Properties();
        this.props.load(new ByteArrayInputStream(propertiesFile.toBytes()));
    }

    public void testSanity() {
        TestIPropertySymbolItemProvider.assertEquals((int)this.props.size(), (int)3);
    }

    public void testProposalConstructionForMap() {
        IMapTypeDescriptor mapDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        mapDesc.setImmutable(true);
        mapDesc.setMapSource((Map)this.props);
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName("myTestSymbol");
        symbol.setTypeDescriptor((ITypeDescriptor)mapDesc);
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        MyCompletionFactory creationInfo = new MyCompletionFactory();
        for (ISymbol propSymbol : symbol.getTypeDescriptor().getProperties()) {
            Adapter provider = factory.adapt((Notifier)propSymbol, IContentProposalProvider.class);
            TestIPropertySymbolItemProvider.assertTrue((boolean)(provider instanceof IContentProposalProvider));
            ICompletionProposal[] proposal = ((IContentProposalProvider)provider).getProposals((Object)propSymbol, (IContentProposalProvider.IProposalCreationFactory)creationInfo);
            TestIPropertySymbolItemProvider.assertNotNull((Object)proposal);
        }
        List list = creationInfo._replacementText;
        TestIPropertySymbolItemProvider.assertEquals((int)list.size(), (int)3);
        for (String replacementText : list) {
            if (replacementText.startsWith("['")) {
                replacementText = replacementText.substring(2);
                replacementText = replacementText.substring(0, replacementText.length() - 2);
            }
            TestIPropertySymbolItemProvider.assertTrue((boolean)this.props.containsKey(replacementText));
        }
    }

    private class MyCompletionFactory
    extends ProposalCreationFactoryAdapter {
        final List _replacementText;

        public MyCompletionFactory() {
            super(0, 0);
            this._replacementText = new ArrayList();
        }

        public ICompletionProposal createProposal(String replacementText, String displayText, String additionalText, Image displayImage, Object targetObject) {
            this._replacementText.add(replacementText);
            return super.createProposal(replacementText, displayText, additionalText, displayImage, targetObject);
        }
    }
}

