/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JSFUtils {
    public static final String JSF_DEFAULT_SERVLET_NAME = "Faces Servlet";
    public static final String JSF_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    public static final String JSF_CONFIG_CONTEXT_PARAM = "javax.faces.CONFIG_FILES";
    public static final String JSF_DEFAULT_SUFFIX_CONTEXT_PARAM = "javax.faces.DEFAULT_SUFFIX";
    public static final String JSF_DEFAULT_CONFIG_PATH = "/WEB-INF/faces-config.xml";
    public static final String JSF_DEFAULT_URL_MAPPING = "/faces/*";
    public static final String PP_JSF_IMPLEMENTATION_LIBRARIES = "jsf.implementation.libraries";
    public static final String PP_JSF_COMPONENT_LIBRARIES = "jsf.component.libraries";
    public static final String PP_JSF_IMPLEMENTATION_TYPE = "jsf.implementation.type";

    public static IPath[] getJARPathforJSFLibwFilterMissingJars(JSFLibrary jsfLib, boolean logMissingJar) {
        EList archiveFiles = jsfLib.getArchiveFiles();
        int numJars = JSFUtils.numberofValidJar(archiveFiles);
        IPath[] elements = new IPath[numJars];
        ArchiveFile ar = null;
        int idxValidJar = 0;
        int i = 0;
        while (i < archiveFiles.size()) {
            ar = (ArchiveFile)archiveFiles.get(i);
            if (!ar.exists()) {
                if (logMissingJar) {
                    JSFUtils.logErroronMissingJAR(jsfLib, ar);
                }
            } else {
                elements[idxValidJar] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
                ++idxValidJar;
            }
            ++i;
        }
        return elements;
    }

    public static IPath[] getJARPathforJSFLib(JSFLibrary jsfLib, boolean logMissingJar) {
        EList archiveFiles = jsfLib.getArchiveFiles();
        int numJars = archiveFiles.size();
        IPath[] elements = new IPath[numJars];
        ArchiveFile ar = null;
        int i = 0;
        while (i < numJars) {
            ar = (ArchiveFile)archiveFiles.get(i);
            if (!ar.exists() && logMissingJar) {
                JSFUtils.logErroronMissingJAR(jsfLib, ar);
            }
            elements[i] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
            ++i;
        }
        return elements;
    }

    private static int numberofValidJar(EList archiveFiles) {
        int total = 0;
        Iterator it = archiveFiles.iterator();
        ArchiveFile ar = null;
        while (it.hasNext()) {
            ar = (ArchiveFile)it.next();
            if (!ar.exists()) continue;
            ++total;
        }
        return total;
    }

    private static void logErroronMissingJAR(JSFLibrary jsfLib, ArchiveFile ar) {
        String msg = NLS.bind((String)Messages.JSFUtils_MissingJAR, (Object)ar.getName(), (Object)jsfLib.getLabel());
        JSFCorePlugin.log(4, msg);
    }

    protected static String getDisplayName(IDataModel config) {
        String displayName = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        if (displayName.equals("")) {
            displayName = JSF_DEFAULT_SERVLET_NAME;
        }
        return displayName;
    }

    protected static String getServletClassname(IDataModel config) {
        String className = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        if (className.equals("")) {
            className = JSF_SERVLET_CLASS;
        }
        return className;
    }
}

