/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigProvider;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigResourceFactory;
import org.eclipse.osgi.util.NLS;

public class JARFileJSFAppConfigProvider
extends AbstractJSFAppConfigProvider {
    public static final String JARFILE_URI_PREFIX = "jar:file:///";
    public static final String FACES_CONFIG_IN_JAR_SUFFIX = "!/META-INF/faces-config.xml";
    protected String filename = null;
    protected FacesConfigType facesConfig = null;
    protected boolean loadErrorLogged = false;

    public JARFileJSFAppConfigProvider(String filename) {
        this.filename = filename;
    }

    public FacesConfigType getFacesConfigModel() {
        if (this.facesConfig == null && this.filename != null) {
            this.facesConfig = this.getFacesConfig();
            if (this.facesConfig != null) {
                this.jsfAppConfigLocater.getJSFAppConfigManager().addFacesConfigChangeAdapter(this.facesConfig);
            }
        }
        return this.facesConfig;
    }

    public void releaseFacesConfigModel() {
        this.jsfAppConfigLocater.getJSFAppConfigManager().removeFacesConfigChangeAdapter(this.facesConfig);
    }

    protected void logLoadError(Throwable ex) {
        if (!this.loadErrorLogged) {
            JSFCorePlugin.log(4, NLS.bind((String)Messages.JARFileJSFAppConfigProvider_ErrorLoadingModel, (Object)(JARFILE_URI_PREFIX + this.filename + FACES_CONFIG_IN_JAR_SUFFIX)), ex);
            this.loadErrorLogged = true;
        }
    }

    public boolean equals(Object otherObject) {
        boolean equals = false;
        if (otherObject instanceof JARFileJSFAppConfigProvider) {
            String otherFilename = ((JARFileJSFAppConfigProvider)otherObject).filename;
            equals = this.filename != null ? this.filename.equals(otherFilename) : otherFilename == null;
        }
        return equals;
    }

    public int hashCode() {
        return this.filename != null ? this.filename.hashCode() : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JARFileJSFAppConfigProvider[");
        if (this.filename != null) {
            sb.append(this.filename);
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }

    private FacesConfigType getFacesConfig() {
        JarFile jarFile = null;
        File tempFile = null;
        OutputStream tempFileStream = null;
        try {
            jarFile = new JarFile(this.filename);
            ZipEntry entry = jarFile.getEntry("META-INF/faces-config.xml");
            if (entry != null) {
                InputStream stream = jarFile.getInputStream(entry);
                tempFile = File.createTempFile("tempfile", ".xml");
                tempFileStream = new FileOutputStream(tempFile);
                int read = 0;
                byte[] buffer = new byte[4096];
                while ((read = stream.read(buffer)) != -1) {
                    tempFileStream.write(buffer, 0, read);
                }
                tempFileStream.close();
                tempFileStream = null;
                FacesConfigResourceFactory factory = FacesConfigResourceFactory.createResourceFactoryForJar();
                Resource resource = factory.createResource(URI.createFileURI((String)tempFile.getAbsolutePath()));
                try {
                    EList resourceContents;
                    resource.load(Collections.EMPTY_MAP);
                    if (resource != null && (resourceContents = resource.getContents()) != null && resourceContents.size() > 0) {
                        this.facesConfig = (FacesConfigType)resourceContents.get(0);
                        if (this.facesConfig != null) {
                            this.jsfAppConfigLocater.getJSFAppConfigManager().addFacesConfigChangeAdapter(this.facesConfig);
                        }
                    }
                }
                catch (IllegalStateException ise) {
                    this.logLoadError(ise);
                }
                catch (IOException ioe) {
                    this.logLoadError(ioe);
                }
            }
            FacesConfigType facesConfigType = this.facesConfig;
            return facesConfigType;
        }
        catch (IOException ioe) {
            this.logLoadError(ioe);
            return null;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {
                    this.logLoadError(ioe);
                }
            }
            if (tempFileStream != null) {
                try {
                    tempFileStream.close();
                }
                catch (IOException ioe) {
                    this.logLoadError(ioe);
                }
            }
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }
}

