/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPModelProcessor {
    private static final Map<IFile, JSPModelProcessor> RESOURCE_MAP = new HashMap<IFile, JSPModelProcessor>();
    private static final Lock CRITICAL_SECTION = new ReentrantLock();
    private static LifecycleListener LIFECYCLE_LISTENER;
    private final IFile _file;
    private LifecycleListener _lifecycleListener;
    private IResourceLifecycleListener _resListener;
    private boolean _isDisposed;
    private Map<Object, ISymbol> _requestMap;
    private Map<Object, ISymbol> _sessionMap;
    private Map<Object, ISymbol> _applicationMap;
    private Map<Object, ISymbol> _noneMap;
    private long _lastModificationStamp;
    private final CountingMutex _lastModificationStampMonitor = new CountingMutex();

    public static JSPModelProcessor get(IFile file) throws CoreException {
        CRITICAL_SECTION.lock();
        try {
            if (!file.isAccessible()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "File must be accessible"));
            }
            JSPModelProcessor processor = RESOURCE_MAP.get(file);
            if (processor == null) {
                if (LIFECYCLE_LISTENER == null) {
                    LIFECYCLE_LISTENER = new LifecycleListener((IResource)file);
                } else {
                    LIFECYCLE_LISTENER.addResource((IResource)file);
                }
                processor = new JSPModelProcessor(file, LIFECYCLE_LISTENER);
                RESOURCE_MAP.put(file, processor);
            }
            JSPModelProcessor jSPModelProcessor = processor;
            return jSPModelProcessor;
        }
        finally {
            CRITICAL_SECTION.unlock();
        }
    }

    private static void dispose(IFile file) {
        CRITICAL_SECTION.lock();
        try {
            JSPModelProcessor processor = RESOURCE_MAP.get(file);
            if (processor != null) {
                RESOURCE_MAP.remove(file);
                if (!processor.isDisposed()) {
                    processor.dispose();
                    LIFECYCLE_LISTENER.removeResource((IResource)file);
                }
            }
            if (RESOURCE_MAP.size() == 0) {
                LIFECYCLE_LISTENER.dispose();
                LIFECYCLE_LISTENER = null;
            }
        }
        finally {
            CRITICAL_SECTION.unlock();
        }
    }

    private JSPModelProcessor(IFile file, LifecycleListener lifecycleListener) {
        this._file = file;
        this._lifecycleListener = lifecycleListener;
        this._resListener = new IResourceLifecycleListener(){

            public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
                IResourceLifecycleListener.EventResult result = IResourceLifecycleListener.EventResult.getDefaultEventResult();
                if (!JSPModelProcessor.this._file.equals((Object)event.getAffectedResource())) {
                    return result;
                }
                if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE) {
                    JSPModelProcessor.dispose(JSPModelProcessor.this._file);
                } else if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_CHANGED && event.getReasonType() == ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS) {
                    JSPModelProcessor.this.refresh(false);
                }
                return result;
            }
        };
        lifecycleListener.addListener(this._resListener);
        this._lastModificationStamp = -1L;
    }

    private DOMModelForJSP getModelForFile(IFile file) throws CoreException, IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.getModelForRead(file);
        if (model instanceof DOMModelForJSP) {
            return (DOMModelForJSP)model;
        }
        if (model != null) {
            model.releaseFromRead();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.blah", 0, "model not of expected type", new Throwable()));
    }

    private void dispose() {
        if (!this._isDisposed) {
            this._lifecycleListener.removeListener(this._resListener);
            this._resListener = null;
            this._lifecycleListener = null;
            if (this._requestMap != null) {
                this._requestMap.clear();
                this._requestMap = null;
            }
            if (this._sessionMap != null) {
                this._sessionMap.clear();
                this._sessionMap = null;
            }
            if (this._applicationMap != null) {
                this._applicationMap.clear();
                this._applicationMap = null;
            }
            if (this._noneMap != null) {
                this._noneMap.clear();
                this._noneMap = null;
            }
            this._isDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this._isDisposed;
    }

    public boolean isModelDirty() {
        long currentModificationStamp = this._file.getModificationStamp();
        return this._lastModificationStamp != currentModificationStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean forceRefresh) {
        if (this.isDisposed()) {
            throw new IllegalStateException("Processor is disposed for file: " + this._file.toString());
        }
        CountingMutex countingMutex = this._lastModificationStampMonitor;
        synchronized (countingMutex) {
            block15: {
                block16: {
                    if (this._lastModificationStampMonitor.isSignalled()) {
                        return;
                    }
                    DOMModelForJSP model = null;
                    try {
                        this._lastModificationStampMonitor.setSignalled(true);
                        if (forceRefresh || this.isModelDirty()) {
                            model = this.getModelForFile(this._file);
                            this.refreshInternal(model);
                            this._lastModificationStamp = this._file.getModificationStamp();
                        }
                    }
                    catch (CoreException e) {
                        JSFCorePlugin.log(new RuntimeException(e), "Error refreshing internal model");
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        this._lastModificationStampMonitor.setSignalled(false);
                        break block15;
                    }
                    catch (IOException e) {
                        try {
                            JSFCorePlugin.log(new RuntimeException(e), "Error refreshing internal model");
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (model != null) {
                                model.releaseFromRead();
                            }
                            this._lastModificationStampMonitor.setSignalled(false);
                        }
                    }
                    if (model == null) break block16;
                    model.releaseFromRead();
                }
                this._lastModificationStampMonitor.setSignalled(false);
            }
        }
    }

    private void refreshInternal(DOMModelForJSP model) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), -1);
        ITaglibContextResolver taglibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        IDOMDocument document = model.getDocument();
        this.getApplicationMap().clear();
        this.getRequestMap().clear();
        this.getSessionMap().clear();
        this.recurseChildNodes(model, document.getChildNodes(), taglibResolver);
    }

    private void recurseChildNodes(DOMModelForJSP model, NodeList nodes, ITaglibContextResolver taglibResolver) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            this.processAttributes(model, child, taglibResolver);
            this.recurseChildNodes(model, child.getChildNodes(), taglibResolver);
            ++i;
        }
    }

    private void processAttributes(DOMModelForJSP model, Node node, ITaglibContextResolver taglibResolver) {
        if (taglibResolver.hasTag(node)) {
            String uri = taglibResolver.getTagURIForNodeName(node);
            String elementName = node.getLocalName();
            int i = 0;
            while (i < node.getAttributes().getLength()) {
                Node attribute = node.getAttributes().item(i);
                this.processSymbolContrib(model, uri, elementName, attribute);
                this.processSetsLocale(uri, elementName, attribute);
                ++i;
            }
        }
    }

    private void processSymbolContrib(DOMModelForJSP model, String uri, String elementName, Node attribute) {
        SymbolContribAggregator aggregator = SymbolContribAggregator.create(this._file.getProject(), uri, elementName, attribute.getLocalName());
        if (aggregator != null) {
            AbstractContextSymbolFactory factory = aggregator.getFactory();
            String symbolName = attribute.getNodeValue();
            if (factory != null) {
                ArrayList problems = new ArrayList();
                ISymbol symbol = factory.create(symbolName, 1, (IAdaptable)IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), attribute), problems);
                if (symbol != null) {
                    this.updateMap(symbol, aggregator.getScope());
                }
            } else {
                IComponentSymbol componentSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
                componentSymbol.setName(symbolName);
                this.updateMap((ISymbol)componentSymbol, aggregator.getScope());
            }
        }
    }

    private void processSetsLocale(String uri, String elementName, Node attribute) {
        DesignTimeApplicationManager dtAppMgr;
        DTFacesContext facesContext;
        LocaleSetAggregator aggregator = LocaleSetAggregator.create(this._file.getProject(), uri, elementName, attribute.getLocalName());
        if (aggregator != null && (facesContext = (dtAppMgr = DesignTimeApplicationManager.getInstance(this._file.getProject())).getFacesContext(this._file)) != null) {
            facesContext.setLocaleString(attribute.getNodeValue());
        }
    }

    public Map<Object, ISymbol> getMapForScope(String scopeName) {
        Map<Object, ISymbol> map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.EMPTY_MAP;
    }

    private void updateMap(ISymbol symbol, String scopeName) {
        Map<Object, ISymbol> map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            map.put(symbol.getName(), symbol);
        } else {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Scope not found: " + scopeName, new Throwable()));
        }
    }

    private Map<Object, ISymbol> getMapForScopeInternal(String scopeName) {
        if ("request".equals(scopeName)) {
            return this.getRequestMap();
        }
        if ("session".equals(scopeName)) {
            return this.getSessionMap();
        }
        if ("application".equals(scopeName)) {
            return this.getApplicationMap();
        }
        if ("none".equals(scopeName)) {
            return this.getNoneMap();
        }
        Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Scope not found: " + scopeName, new Throwable()));
        return null;
    }

    private Map getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new HashMap<Object, ISymbol>();
        }
        return this._requestMap;
    }

    private Map<Object, ISymbol> getSessionMap() {
        if (this._sessionMap == null) {
            this._sessionMap = new HashMap<Object, ISymbol>();
        }
        return this._sessionMap;
    }

    private Map<Object, ISymbol> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new HashMap<Object, ISymbol>();
        }
        return this._applicationMap;
    }

    private Map<Object, ISymbol> getNoneMap() {
        if (this._noneMap == null) {
            this._noneMap = new HashMap<Object, ISymbol>();
        }
        return this._noneMap;
    }

    private static class CountingMutex {
        private boolean _signalled = false;

        private CountingMutex() {
        }

        public synchronized boolean isSignalled() {
            return this._signalled;
        }

        public synchronized void setSignalled(boolean signalled) {
            this._signalled = signalled;
        }
    }

    private static class LocaleSetAggregator {
        private static final String SETS_LOCALE = "sets-locale";

        private LocaleSetAggregator() {
        }

        static LocaleSetAggregator create(IProject project, String uri, String elementName, String attributeName) {
            ITaglibDomainMetaDataModelContext mdContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)uri);
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)(String.valueOf(elementName) + "/" + attributeName), (String)SETS_LOCALE);
            if (TraitValueHelper.getValueAsBoolean((Trait)trait)) {
                return new LocaleSetAggregator();
            }
            return null;
        }
    }

    private static class SymbolContribAggregator {
        private static final String CONTRIBUTES_VALUE_BINDING = "contributes-value-binding";
        private static final String VALUE_BINDING_SCOPE = "value-binding-scope";
        private static final String VALUE_BINDING_SYMBOL_FACTORY = "value-binding-symbol-factory";
        private final Map _metadata = new HashMap(4);

        static SymbolContribAggregator create(IProject project, String uri, String elementName, String attributeName) {
            String entityKey = String.valueOf(elementName) + "/" + attributeName;
            ITaglibDomainMetaDataModelContext mdContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)uri);
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)CONTRIBUTES_VALUE_BINDING);
            boolean contribsValueBindings = TraitValueHelper.getValueAsBoolean((Trait)trait);
            if (contribsValueBindings) {
                String scope = null;
                String symbolFactory = null;
                trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)VALUE_BINDING_SCOPE);
                scope = TraitValueHelper.getValueAsString((Trait)trait);
                if (scope != null && !scope.equals("")) {
                    trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)VALUE_BINDING_SYMBOL_FACTORY);
                    symbolFactory = TraitValueHelper.getValueAsString((Trait)trait);
                }
                return new SymbolContribAggregator(scope, symbolFactory);
            }
            return null;
        }

        SymbolContribAggregator(String scope, String factory) {
            this._metadata.put("scope", scope);
            this._metadata.put("factory", factory);
        }

        public String getScope() {
            return (String)this._metadata.get("scope");
        }

        public AbstractContextSymbolFactory getFactory() {
            return (AbstractContextSymbolFactory)JSFCommonPlugin.getSymbolFactories().get(this._metadata.get("factory"));
        }
    }
}

