/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentClassType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacetNameType;
import org.eclipse.jst.jsf.validation.internal.appconfig.AttributeValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.ClassNameEObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.EObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.PropertyValidationVisitor;

public class ComponentValidatorVisitor
extends EObjectValidationVisitor {
    public ComponentValidatorVisitor(String version) {
        super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getFacesConfigType_Component(), version);
    }

    protected void doValidate(EObject object, List messages, IFile file) {
    }

    protected EObjectValidationVisitor[] getChildNodeValidators() {
        return new EObjectValidationVisitor[]{new ComponentClassValidationVisitor(this.getVersion()), new AttributeValidationVisitor((EStructuralFeature)FacesConfigPackage.eINSTANCE.getComponentType_Attribute(), this.getVersion()), new PropertyValidationVisitor((EStructuralFeature)FacesConfigPackage.eINSTANCE.getComponentType_Property(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getComponentType_ComponentClass(), this.getVersion()), new ComponentFacetValidationVisitor(this.getVersion())};
    }

    private static class ComponentClassValidationVisitor
    extends ClassNameEObjectValidationVisitor {
        ComponentClassValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getComponentType_ComponentClass(), version);
        }

        protected String getFullyQualifiedName(EObject eobj) {
            return ((ComponentClassType)eobj).getTextContent();
        }

        protected String getInstanceOf() {
            return "javax.faces.component.UIComponent";
        }

        protected EObjectValidationVisitor[] getChildNodeValidators() {
            return NO_CHILDREN;
        }
    }

    private static class ComponentFacetValidationVisitor
    extends EObjectValidationVisitor {
        public ComponentFacetValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getComponentType_Facet(), version);
        }

        protected void doValidate(EObject object, List messages, IFile file) {
        }

        protected EObjectValidationVisitor[] getChildNodeValidators() {
            return new EObjectValidationVisitor[]{new FacetNameValidationVisitor(this.getVersion())};
        }

        private static class FacetNameValidationVisitor
        extends EObjectValidationVisitor {
            public FacetNameValidationVisitor(String version) {
                super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getFacetType_FacetName(), version);
            }

            protected void doValidate(EObject object, List messages, IFile file) {
                FacetNameType name = (FacetNameType)object;
                boolean isValid = false;
                if (name.getTextContent() != null || "".equals(name.getTextContent().trim())) {
                    String nameValue = name.getTextContent().trim();
                    if (Character.isJavaIdentifierStart(nameValue.charAt(0))) {
                        // empty if block
                    }
                    isValid = true;
                    int i = 1;
                    while (i < nameValue.length()) {
                        if (!Character.isJavaIdentifierPart(nameValue.charAt(i))) {
                            isValid = false;
                        }
                        ++i;
                    }
                }
                if (!isValid) {
                    FacetNameValidationVisitor.addMessageInfo(messages, DiagnosticFactory.create_MUST_BE_A_VALID_JAVA_IDENT("Facet name"), object, file);
                }
            }

            protected EObjectValidationVisitor[] getChildNodeValidators() {
                return NO_CHILDREN;
            }
        }
    }
}

