/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.common.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.ArithmeticBinaryOperator;

class ModArithmeticBinaryOperator
extends ArithmeticBinaryOperator {
    private static final String MODULO = "modulo";

    ModArithmeticBinaryOperator(DiagnosticFactory diagnosticFactory) {
        super(diagnosticFactory);
    }

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return IntegerLiteralType.ZERO;
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstArg) || "Ljava.math.BigDecimal;".equals(boxedSecondArg) || "Ljava.lang.Double;".equals(boxedFirstArg) || "Ljava.lang.Double;".equals(boxedSecondArg) || "Ljava.lang.Float;".equals(boxedFirstArg) || "Ljava.lang.Float;".equals(boxedSecondArg)) {
            return this.performDouble(firstArg, secondArg);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.performBigInteger(firstArg, secondArg);
        }
        return this.performLong(firstArg, secondArg);
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return this._diagnosticFactory.create_BINARY_OP_BOTH_OPERANDS_NULL(MODULO);
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstArg) || "Ljava.math.BigDecimal;".equals(boxedSecondArg) || "Ljava.lang.Double;".equals(boxedFirstArg) || "Ljava.lang.Double;".equals(boxedSecondArg) || "Ljava.lang.Float;".equals(boxedFirstArg) || "Ljava.lang.Float;".equals(boxedSecondArg)) {
            return this.validateDouble(firstArg, secondArg);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.validateBigInteger(firstArg, secondArg);
        }
        return this.validateLong(firstArg, secondArg);
    }

    private ValueType performDouble(ValueType firstArg, ValueType secondArg) {
        Number secondValue;
        block5: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                secondValue = null;
                if (!(secondArg instanceof LiteralType) || (secondValue = ((LiteralType)secondArg).coerceToNumber(Double.class)).doubleValue() != 0.0) break block5;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        Number firstValue = null;
        if (firstArg instanceof LiteralType) {
            firstValue = ((LiteralType)firstArg).coerceToNumber(Double.class);
        }
        if (firstValue != null && secondValue != null) {
            return new FloatLiteralType(this.doRealOperation(new Double(firstValue.doubleValue()), new Double(secondValue.doubleValue())).doubleValue());
        }
        return new ValueType("D", 2);
    }

    private ValueType performBigInteger(ValueType firstArg, ValueType secondArg) {
        block3: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                if (!(secondArg instanceof LiteralType) || !((LiteralType)secondArg).coerceToNumber(BigInteger.class).equals(BigInteger.ZERO)) break block3;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        return new ValueType("Ljava.math.BigInteger;", 2);
    }

    private ValueType performLong(ValueType firstArg, ValueType secondArg) {
        Number secondValue;
        block5: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                secondValue = null;
                if (!(secondArg instanceof LiteralType) || (secondValue = ((LiteralType)secondArg).coerceToNumber(Long.class)).longValue() != 0L) break block5;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        Number firstValue = null;
        if (firstArg instanceof LiteralType) {
            firstValue = ((LiteralType)firstArg).coerceToNumber(Long.class);
        }
        if (firstValue != null && secondValue != null) {
            return new IntegerLiteralType(this.doRealOperation(new Long(firstValue.longValue()), new Long(secondValue.longValue())).longValue());
        }
        return new ValueType("J", 2);
    }

    private Diagnostic validateDouble(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            Number secondValue = null;
            if (secondArg instanceof LiteralType && (secondValue = ((LiteralType)secondArg).coerceToNumber(Double.class)).doubleValue() == 0.0) {
                return this._diagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
            }
            Number firstValue = null;
            if (firstArg instanceof LiteralType) {
                firstValue = ((LiteralType)firstArg).coerceToNumber(Double.class);
            }
            if (firstValue != null && secondValue != null) {
                return this._diagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(MODULO, Double.toString(firstValue.doubleValue() % secondValue.doubleValue()));
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return this._diagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(MODULO);
        }
    }

    private Diagnostic validateBigInteger(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            if (secondArg instanceof LiteralType && ((LiteralType)secondArg).coerceToNumber(BigInteger.class).equals(BigInteger.ZERO)) {
                return this._diagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return this._diagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(MODULO);
        }
    }

    private Diagnostic validateLong(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            Number secondValue = null;
            if (secondArg instanceof LiteralType && (secondValue = ((LiteralType)secondArg).coerceToNumber(Long.class)).longValue() == 0L) {
                return this._diagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
            }
            Number firstValue = null;
            if (firstArg instanceof LiteralType) {
                firstValue = ((LiteralType)firstArg).coerceToNumber(Long.class);
            }
            if (firstValue != null && secondValue != null) {
                return this._diagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(MODULO, Long.toString(firstValue.longValue() % secondValue.longValue()));
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return this._diagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(MODULO);
        }
    }

    protected Long doRealOperation(Long firstArg, Long secondArg) {
        return new Long(firstArg % secondArg);
    }

    protected Double doRealOperation(Double firstArg, Double secondArg) {
        return new Double(firstArg % secondArg);
    }

    protected BigDecimal doRealOperation(BigDecimal firstArg, BigDecimal secondArg) {
        return new BigDecimal(firstArg.doubleValue() % secondArg.doubleValue());
    }

    protected String getOperatorName() {
        return MODULO;
    }
}

