/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import junit.framework.TestCase;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.util.IObjectSymbolBasedValueType;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.internal.symbols.DataModelVariableTestFacade;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestAbstractDataModelVariableFactory
extends TestCase {
    private JSFFacetedTestEnvironment _jsfFacetedTestEnvironment;
    private JDTTestEnvironment _jdtTestEnvironment;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestAbstractDataModelFactory" + this.getName());
        projectTestEnvironment.createProject(false);
        this._jsfFacetedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFacetedTestEnvironment.initialize("1.1");
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._jdtTestEnvironment.getJavaProject().getProject().delete(true, null);
    }

    public final void testCreateArraySymbol() {
        this.createAndVerifyArraySymbol("intArray", "I", 1, "I", 0);
        this.createAndVerifyArraySymbol("stringArray", "Ljava.lang.String;", 1, "Ljava.lang.String;", 0);
        this.createAndVerifyArraySymbol("stringArrayArray", "Ljava.lang.String;", 2, "Ljava.lang.String;", 1);
    }

    private ISymbol createAndVerifyArraySymbol(String name, String typeSignature, int arrayCount, String expectedResultSignature, int expectedArrayCount) {
        DataModelVariableTestFacade testFacade = new DataModelVariableTestFacade();
        ISymbol symbol = testFacade.testCreateArraySymbol(name, Signature.createArraySignature((String)typeSignature, (int)arrayCount), this._jdtTestEnvironment.getJavaProject());
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(symbol instanceof IInstanceSymbol));
        IInstanceSymbol instanceSymbol = (IInstanceSymbol)symbol;
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(instanceSymbol.getTypeDescriptor() instanceof IJavaTypeDescriptor2));
        IJavaTypeDescriptor2 typeDesc = (IJavaTypeDescriptor2)instanceSymbol.getTypeDescriptor();
        TestAbstractDataModelVariableFactory.assertEquals((String)name, (String)symbol.getName());
        TestAbstractDataModelVariableFactory.assertEquals((String)Signature.createArraySignature((String)expectedResultSignature, (int)expectedArrayCount), (String)typeDesc.getTypeSignature());
        TestAbstractDataModelVariableFactory.assertEquals((int)expectedArrayCount, (int)typeDesc.getArrayCount());
        return symbol;
    }

    public final void testCreateFromList() {
        String[] stringArgType = new String[]{"Ljava.lang.String;"};
        String[] listOfStringArgType = new String[]{"Ljava.util.List<Ljava.lang.String;>;"};
        DataModelVariableTestFacade testFacade = new DataModelVariableTestFacade();
        ValueType valueType = new ValueType("Ljava.util.List;", new String[0], new String[0], new String[0], false, 2);
        ISymbol symbol = testFacade.testCreateFromList("rawList", valueType, this._jdtTestEnvironment.getJavaProject());
        ISymbol compareSymbol = testFacade.createDefaultSymbol("rawListDefault");
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(symbol instanceof IComponentSymbol));
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(compareSymbol instanceof IComponentSymbol));
        IComponentSymbol s1 = (IComponentSymbol)symbol;
        IComponentSymbol s2 = (IComponentSymbol)compareSymbol;
        this.assertSame(s1, s2);
        valueType = new ValueType("Ljava.util.List;", stringArgType, new String[0], new String[0], false, 2);
        symbol = testFacade.testCreateFromList("string", valueType, this._jdtTestEnvironment.getJavaProject());
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(symbol instanceof IComponentSymbol));
        TestAbstractDataModelVariableFactory.assertEquals((Object)ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, (Object)((IComponentSymbol)symbol).getRuntimeSource());
        TestAbstractDataModelVariableFactory.assertEquals((String)"Ljava.lang.String;", (String)((IComponentSymbol)symbol).getTypeDescriptor().getTypeSignature());
        TestAbstractDataModelVariableFactory.assertEquals((int)0, (int)((IComponentSymbol)symbol).getTypeDescriptor().getTypeParameterSignatures().size());
        valueType = new ValueType("Ljava.util.List;", listOfStringArgType, new String[0], new String[0], false, 2);
        symbol = testFacade.testCreateFromList("listOfString", valueType, this._jdtTestEnvironment.getJavaProject());
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(symbol instanceof IComponentSymbol));
        TestAbstractDataModelVariableFactory.assertEquals((Object)ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, (Object)((IComponentSymbol)symbol).getRuntimeSource());
        TestAbstractDataModelVariableFactory.assertEquals((String)"Ljava.util.List;", (String)((IComponentSymbol)symbol).getTypeDescriptor().getTypeSignature());
        TestAbstractDataModelVariableFactory.assertEquals((int)1, (int)((IComponentSymbol)symbol).getTypeDescriptor().getTypeParameterSignatures().size());
        TestAbstractDataModelVariableFactory.assertEquals((Object)"Ljava.lang.String;", (Object)((IComponentSymbol)symbol).getTypeDescriptor().getTypeParameterSignatures().get(0));
        valueType = IObjectSymbolBasedValueType.getInstance((ISymbol)symbol);
        symbol = testFacade.testCreateFromList("subListOfString", valueType, this._jdtTestEnvironment.getJavaProject());
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(symbol instanceof IComponentSymbol));
        TestAbstractDataModelVariableFactory.assertEquals((Object)ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, (Object)((IComponentSymbol)symbol).getRuntimeSource());
        TestAbstractDataModelVariableFactory.assertEquals((String)"Ljava.lang.String;", (String)((IComponentSymbol)symbol).getTypeDescriptor().getTypeSignature());
        TestAbstractDataModelVariableFactory.assertEquals((int)0, (int)((IComponentSymbol)symbol).getTypeDescriptor().getTypeParameterSignatures().size());
    }

    private void assertSame(IComponentSymbol s1, IComponentSymbol s2) {
        TestAbstractDataModelVariableFactory.assertFalse((s1 == s2 ? 1 : 0) != 0);
        TestAbstractDataModelVariableFactory.assertEquals((Object)s1.getRuntimeSource(), (Object)s2.getRuntimeSource());
        TestAbstractDataModelVariableFactory.assertEquals((String)s1.getDetailedDescription(), (String)s2.getDetailedDescription());
        TestAbstractDataModelVariableFactory.assertEquals((String)s1.getTypeDescriptor().getTypeSignature(), (String)s2.getTypeDescriptor().getTypeSignature());
    }

    public final void testCreateScalarSymbol() {
        this.createAndVerifyScalar("String", "Ljava.lang.String;");
        this.createAndVerifyScalar("List", "Ljava.util.List;");
        this.createAndVerifyScalar("ListOfString", "Ljava.util.List<Ljava.lang.String;>;");
        this.createAndVerifyScalar("ArrayOfInteger", Signature.createArraySignature((String)"Ljava.lang.Integer;", (int)1));
    }

    private void createAndVerifyScalar(String name, String signature) {
        DataModelVariableTestFacade testFacade = new DataModelVariableTestFacade();
        ISymbol symbol = testFacade.testCreateScalarSymbol("", signature, this._jdtTestEnvironment.getJavaProject());
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(symbol instanceof IComponentSymbol));
        IComponentSymbol compSymbol = (IComponentSymbol)symbol;
        TestAbstractDataModelVariableFactory.assertEquals((Object)ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, (Object)((IComponentSymbol)symbol).getRuntimeSource());
        TestAbstractDataModelVariableFactory.assertEquals((String)Signature.getTypeErasure((String)signature), (String)compSymbol.getTypeDescriptor().getTypeSignature());
        String[] typeArgs = Signature.getTypeArguments((String)signature);
        int i = 0;
        while (i < typeArgs.length) {
            TestAbstractDataModelVariableFactory.assertEquals((Object)typeArgs[i], (Object)compSymbol.getTypeDescriptor().getTypeParameterSignatures().get(i));
            ++i;
        }
    }

    public final void testCreateDefaultSymbol() {
        DataModelVariableTestFacade testFacade = new DataModelVariableTestFacade();
        ISymbol defaultSymbol = testFacade.createDefaultSymbol("foo");
        TestAbstractDataModelVariableFactory.assertNotNull((Object)defaultSymbol);
        TestAbstractDataModelVariableFactory.assertEquals((String)"foo", (String)defaultSymbol.getName());
        TestAbstractDataModelVariableFactory.assertTrue((boolean)(defaultSymbol instanceof IComponentSymbol));
        IComponentSymbol symbol = (IComponentSymbol)defaultSymbol;
        assert (symbol.getTypeDescriptor() instanceof IBoundedMapTypeDescriptor);
        TestAbstractDataModelVariableFactory.assertEquals((Object)ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, (Object)symbol.getRuntimeSource());
        TestAbstractDataModelVariableFactory.assertNotNull((Object)symbol.getDetailedDescription());
    }

    public final void testCreateFromType() {
        DataModelVariableTestFacade testFacade = new DataModelVariableTestFacade();
        ValueType valueType = new ValueType("[Ljava.lang.String;", new String[0], new String[0], new String[0], false, 2);
        ISymbol array1 = testFacade.createFromType("array", valueType, this._jdtTestEnvironment.getJavaProject());
        ISymbol array2 = testFacade.testCreateArraySymbol("array2", "[Ljava.lang.String;", this._jdtTestEnvironment.getJavaProject());
        this.assertSame((IComponentSymbol)array1, (IComponentSymbol)array2);
        valueType = new ValueType("Ljava.util.List;", new String[0], new String[0], new String[0], false, 2);
        ISymbol list1 = testFacade.createFromType("list", valueType, this._jdtTestEnvironment.getJavaProject());
        ISymbol list2 = testFacade.testCreateFromList("list2", valueType, this._jdtTestEnvironment.getJavaProject());
        this.assertSame((IComponentSymbol)list1, (IComponentSymbol)list2);
        valueType = new ValueType("Ljavax.faces.model.DataModel;", new String[0], new String[0], new String[0], false, 2);
        ISymbol dataModel1 = testFacade.createFromType("dataModel", valueType, this._jdtTestEnvironment.getJavaProject());
        ISymbol dataModel2 = testFacade.createDefaultSymbol("dataModel2");
        this.assertSame((IComponentSymbol)dataModel1, (IComponentSymbol)dataModel2);
        valueType = new ValueType("Ljava.lang.String;", new String[0], new String[0], new String[0], false, 2);
        ISymbol scalar1 = testFacade.createFromType("scalar1", valueType, this._jdtTestEnvironment.getJavaProject());
        ISymbol scalar2 = testFacade.testCreateScalarSymbol("scalar2", "Ljava.lang.String;", this._jdtTestEnvironment.getJavaProject());
        this.assertSame((IComponentSymbol)scalar1, (IComponentSymbol)scalar2);
    }
}

