/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.internal;

import java.io.PrintStream;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.facesconfig.FacesConfigPlugin;

public class Logger {
    private static Plugin fPlugin;
    private static String fPluginId;
    private static boolean displayToConsole;
    private static final String TRACEFILTER_LOCATION = "/debug/tracefilter";
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int OK_DEBUG = 200;
    public static final int INFO_DEBUG = 201;
    public static final int WARNING_DEBUG = 202;
    public static final int ERROR_DEBUG = 204;

    static {
        displayToConsole = false;
    }

    protected static void _log(int level, String message, Throwable exception) {
        if (!(level != 200 && level != 201 && level != 202 && level != 204 || Logger.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 201: {
                severity = 1;
                break;
            }
            case 2: 
            case 202: {
                severity = 2;
                break;
            }
            case 4: 
            case 204: {
                severity = 4;
            }
        }
        message = message != null ? message : "null";
        Status statusObj = new Status(severity, Logger.getPluginId(), severity, message, exception);
        Logger.getPlugin().getLog().log((IStatus)statusObj);
    }

    protected static void _trace(String category, String message, Throwable exception) {
        if (Logger.isTracing(category)) {
            message = message != null ? message : "null";
            Status statusObj = new Status(0, Logger.getPluginId(), 0, message, exception);
            Logger.getPlugin().getLog().log((IStatus)statusObj);
        }
    }

    public static boolean isDebugging() {
        return Logger.getPlugin().isDebugging();
    }

    public static boolean isTracing(String category) {
        if (!Logger.isDebugging()) {
            return false;
        }
        String traceFilter = Platform.getDebugOption((String)(String.valueOf(Logger.getPluginId()) + TRACEFILTER_LOCATION));
        if (traceFilter != null) {
            StringTokenizer tokenizer = new StringTokenizer(traceFilter, ",");
            while (tokenizer.hasMoreTokens()) {
                String cat = tokenizer.nextToken().trim();
                if (!category.equals(cat)) continue;
                return true;
            }
        }
        return false;
    }

    public static void log(int level, String message) {
        Logger._log(level, message, null);
    }

    public static void log(int level, String message, Throwable exception) {
        Logger._log(level, message, exception);
    }

    public static void log(Object source, String message) {
        Logger.doLog(source, message, null);
    }

    public static void log(Object source, String message, Throwable throwable) {
        Logger.doLog(source, message, throwable);
    }

    public static void log(Object source, Throwable throwable) {
        Logger.doLog(source, null, throwable);
    }

    public static void log(String message) {
        Logger.doLog(message, null);
    }

    private static void doLog(String message, Throwable exception) {
        Logger._log(4, message, exception);
    }

    private static void doLog(Object source, String message, Throwable exception) {
        Logger._log(4, Logger.getMessageFor(source, message), exception);
    }

    private static final String getMessageFor(Object source, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(source);
        if (message != null) {
            buffer.append(": ");
            buffer.append(message);
        }
        return buffer.toString();
    }

    public static void logException(String message, Throwable exception) {
        Logger._log(4, message, exception);
    }

    public static void logException(Throwable exception) {
        Logger._log(4, exception.getMessage(), exception);
    }

    public static void traceException(String category, String message, Throwable exception) {
        Logger._trace(category, message, exception);
    }

    public static void traceException(String category, Throwable exception) {
        Logger._trace(category, exception.getMessage(), exception);
    }

    public static void trace(String category, String message) {
        Logger._trace(category, message, null);
    }

    private static Plugin getFacesPlugin() {
        return FacesConfigPlugin.getPlugin();
    }

    public static Plugin getPlugin() {
        if (fPlugin == null) {
            fPlugin = Logger.getFacesPlugin();
        }
        return fPlugin;
    }

    public static String getPluginId() {
        if (fPluginId == null) {
            fPluginId = FacesConfigPlugin.getPlugin().getBundle().getSymbolicName();
        }
        return fPluginId;
    }

    private static final void doConsole(String message, Throwable throwable) {
        if (displayToConsole) {
            PrintStream out = System.out;
            out.println(message);
            if (throwable != null) {
                throwable.printStackTrace(out);
            }
        }
    }

    private static final void doTrace(String category, Object source, String message) {
        message = Logger.getMessageFor(source, message);
        try {
            try {
                Logger._trace(category, message, null);
            }
            catch (Exception exception) {
                Logger.doConsole(message, null);
            }
        }
        finally {
            Logger.doConsole(message, null);
        }
    }

    public static void trace(String category, Object source, String message) {
        Logger.doTrace(category, source, message);
    }
}

