/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.table;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.single.SelectEditPartAction;
import org.eclipse.jst.pagedesigner.actions.table.TableOperationContext;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.range.RangeUtil;
import org.eclipse.jst.pagedesigner.tableedit.DeleteRowColumnAction;
import org.eclipse.jst.pagedesigner.tableedit.InsertRowColumnAction;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class TableActionGroup
extends ActionGroup {
    private static final Action action = new Action(){};

    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.getContext().getSelection();
        EditPart part = this.findCommonAncesterPart(selection);
        if (part == null) {
            return;
        }
        TableOperationContext context = TableOperationContext.getTableOperationContext(part);
        if (context == null) {
            return;
        }
        ElementEditPart tablePart = context._tablePart;
        if (tablePart == null || !this.supportTableActions(tablePart)) {
            return;
        }
        int cellRow = context._rowIndex;
        int cellColumn = context._columnIndex;
        String tag = ((IDOMElement)tablePart.getIDOMNode()).getLocalName();
        MenuManager tableMenu = new MenuManager(tag);
        tableMenu.add((IAction)action);
        tableMenu.addMenuListener(new IMenuListener((IMenuManager)tableMenu, tablePart, cellRow, cellColumn){
            private final /* synthetic */ IMenuManager val$tableMenu;
            private final /* synthetic */ ElementEditPart val$tablePart;
            private final /* synthetic */ int val$cellRow;
            private final /* synthetic */ int val$cellColumn;
            {
                this.val$tableMenu = iMenuManager;
                this.val$tablePart = elementEditPart;
                this.val$cellRow = n;
                this.val$cellColumn = n2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$tableMenu.removeAll();
                TableActionGroup.this.fillTableMenu(this.val$tablePart, this.val$cellRow, this.val$cellColumn, this.val$tableMenu);
            }
        });
        menu.appendToGroup("org.eclipse.jst.pagedesigner.container", (IContributionItem)tableMenu);
    }

    private void fillTableMenu(ElementEditPart tablePart, int cellRow, int cellColumn, IMenuManager tableMenu) {
        SelectEditPartAction action1 = SelectEditPartAction.create(PDPlugin.getResourceString("TableActionGroup.Submenu.SelectTable"), (EditPart)tablePart);
        tableMenu.add((IAction)action1);
        tableMenu.add((IContributionItem)new Separator());
        InsertRowColumnAction insertRowBeforeAction = new InsertRowColumnAction(PDPlugin.getResourceString("TableActionGroup.Submenu.InsertRowBefore"), (EditPart)tablePart, cellRow, true, true);
        tableMenu.add((IAction)insertRowBeforeAction);
        InsertRowColumnAction insertRowAfterAction = new InsertRowColumnAction(PDPlugin.getResourceString("TableActionGroup.Submenu.InsertRowAfter"), (EditPart)tablePart, cellRow, true, false);
        tableMenu.add((IAction)insertRowAfterAction);
        tableMenu.add((IContributionItem)new Separator());
        InsertRowColumnAction insertColumnBeforeAction = new InsertRowColumnAction(PDPlugin.getResourceString("TableActionGroup.Submenu.InsertColumnBefore"), (EditPart)tablePart, cellColumn, true, true);
        tableMenu.add((IAction)insertColumnBeforeAction);
        InsertRowColumnAction insertColumnAfterAction = new InsertRowColumnAction(PDPlugin.getResourceString("TableActionGroup.Submenu.InsertColumnAfter"), (EditPart)tablePart, cellColumn, true, false);
        tableMenu.add((IAction)insertColumnAfterAction);
        tableMenu.add((IContributionItem)new Separator());
        DeleteRowColumnAction deleteRowAction = new DeleteRowColumnAction(PDPlugin.getResourceString("TableActionGroup.Submenu.DeleteRow"), (EditPart)tablePart, cellRow, true);
        tableMenu.add((IAction)deleteRowAction);
        DeleteRowColumnAction deleteColumnAction = new DeleteRowColumnAction(PDPlugin.getResourceString("TableActionGroup.Submenu.DeleteColumn"), (EditPart)tablePart, cellColumn, false);
        tableMenu.add((IAction)deleteColumnAction);
    }

    private boolean supportTableActions(ElementEditPart tablePart) {
        return true;
    }

    private EditPart findCommonAncesterPart(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structsel = (IStructuredSelection)selection;
            if (structsel.size() != 1) {
                return null;
            }
            if (structsel.getFirstElement() instanceof EditPart) {
                return (EditPart)structsel.getFirstElement();
            }
            return null;
        }
        if (selection instanceof DesignRange) {
            DesignRange range = (DesignRange)selection;
            if (!range.isValid()) {
                return null;
            }
            if (range.isEmpty()) {
                DesignPosition position = range.getStartPosition();
                if (position.getOffset() == 0) {
                    return position.getContainerPart();
                }
                return position.getSiblingEditPart(true);
            }
            return RangeUtil.findCommonAncestor(range);
        }
        return null;
    }
}

