/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SourceViewerCommand
extends Command {
    protected StructuredTextEditor _editor;
    private Document _document;
    private Logger _log = PDPlugin.getLogger(SourceViewerCommand.class);

    public SourceViewerCommand(String label, StructuredTextEditor editor) {
        this._editor = editor;
        IDOMSourceEditingTextTools tools = this.getSourceEditingTextTools();
        this._document = tools.getDOMDocument();
    }

    protected IDOMSourceEditingTextTools getSourceEditingTextTools() {
        IDOMSourceEditingTextTools tools = (IDOMSourceEditingTextTools)this._editor.getAdapter(ISourceEditingTextTools.class);
        return tools;
    }

    protected final boolean preExecute() {
        int position = 0;
        int length = 0;
        ISelection selection = this._editor.getTextViewer().getSelection();
        if (selection instanceof TextSelection) {
            position = ((TextSelection)selection).getOffset();
            length = ((TextSelection)selection).getLength();
        }
        this.getModel().beginRecording((Object)this, this.getLabel(), position, length);
        this.getModel().aboutToChangeModel();
        return true;
    }

    protected final void postExecute() {
        this.getModel().changedModel();
        this.getModel().endRecording((Object)this);
        this.setSelection();
    }

    public final void formatNode(Node node) {
        new HTMLFormatProcessorImpl().formatNode(node);
    }

    protected IDOMModel getModel() {
        Assert.isTrue((this._document != null && this._document instanceof IDOMNode ? 1 : 0) != 0);
        return ((IDOMNode)this._document).getModel();
    }

    public final void execute() {
        boolean ok = this.preExecute();
        if (ok) {
            try {
                try {
                    this.doExecute();
                }
                catch (Exception ex) {
                    this._log.error("Error.SourceViewerCommand.Execution", (Throwable)ex);
                    this.postExecute();
                }
            }
            finally {
                this.postExecute();
            }
        }
    }

    public abstract void doExecute();

    public abstract void setSelection();
}

