/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.ConverterFacRegistryReader;
import org.eclipse.jst.pagedesigner.converter.DefaultUnknownTagConverter;
import org.eclipse.jst.pagedesigner.converter.DumTagConverter;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.converter.html.HTMLConverterFactory;
import org.eclipse.jst.pagedesigner.converter.jsp.JSPConverterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;

public class ConverterFactoryRegistry {
    List _factories = new ArrayList();
    private static ConverterFactoryRegistry _instance;

    private ConverterFactoryRegistry() {
        this._factories.add(new JSPConverterFactory());
        this._factories.add(new HTMLConverterFactory());
        IConverterFactory[] facs = ConverterFacRegistryReader.getAllHandlers();
        if (facs != null) {
            int i = 0;
            while (i < facs.length) {
                this.addFactory(facs[i]);
                ++i;
            }
        }
    }

    public void addFactory(IConverterFactory fac) {
        this._factories.add(fac);
    }

    public ITagConverter createTagConverter(Element ele, int mode, IDOMDocument targetDocument) {
        ITagConverter converter = this.internalCreateTagConverter(ele, mode);
        if (converter != null) {
            converter.setDestDocument(targetDocument);
        }
        return converter;
    }

    public ITagConverter internalCreateTagConverter(Element ele, int mode) {
        ITagConverter converter;
        String facuri;
        IConverterFactory fac;
        String uri = CMUtil.getElementNamespaceURI((Element)ele);
        int i = 0;
        int size = this._factories.size();
        while (i < size) {
            fac = (IConverterFactory)this._factories.get(i);
            facuri = fac.getSupportedURI();
            if (facuri != null && facuri.equals(uri) && (converter = fac.createConverter(ele, mode)) != null) {
                return converter;
            }
            ++i;
        }
        i = 0;
        size = this._factories.size();
        while (i < size) {
            fac = (IConverterFactory)this._factories.get(i);
            facuri = fac.getSupportedURI();
            if (facuri == null && (converter = fac.createConverter(ele, mode)) != null) {
                return converter;
            }
            ++i;
        }
        if (uri == null || "html".equals(uri)) {
            return new DumTagConverter(ele);
        }
        CMElementDeclaration decl = CMUtil.getElementDeclaration((Element)ele);
        if (decl == null) {
            return new DumTagConverter(ele);
        }
        int contentType = decl.getContentType();
        if (contentType == 1) {
            return new HiddenTagConverter(ele, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ConverterFactoryRegistry.this.getUnknownImage();
                }
            });
        }
        return new DefaultUnknownTagConverter(ele, mode);
    }

    Image getUnknownImage() {
        return PDPlugin.getDefault().getImage("palette/GENERIC/small/PD_Palette_Default.gif");
    }

    public static ConverterFactoryRegistry getInstance() {
        if (_instance == null) {
            _instance = new ConverterFactoryRegistry();
        }
        return _instance;
    }
}

