/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter.jsp;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.converter.TagConverterToDumBlock;
import org.eclipse.jst.pagedesigner.converter.jsp.IncludeTagConverterPreview;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class JSPConverterFactory
implements IConverterFactory {
    private final ILabelProvider _labelProvider = new MyLabelProvider();

    public ITagConverter createConverter(Element element, int mode) {
        String tagName = element.getLocalName();
        if (mode == 1) {
            if ("include".equalsIgnoreCase(tagName)) {
                IncludeTagConverterPreview c = new IncludeTagConverterPreview(element, "page");
                c.setMode(mode);
                return c;
            }
            if ("directive.include".equalsIgnoreCase(tagName)) {
                IncludeTagConverterPreview c = new IncludeTagConverterPreview(element, "file");
                c.setMode(mode);
                return c;
            }
            if ("root".equalsIgnoreCase(tagName)) {
                TagConverterToDumBlock c = new TagConverterToDumBlock(element);
                c.setNeedBorderDecorator(true);
                c.setMode(mode);
                return c;
            }
            return new HiddenTagConverter(element, this._labelProvider);
        }
        if ("root".equalsIgnoreCase(tagName)) {
            TagConverterToDumBlock c = new TagConverterToDumBlock(element);
            c.setNeedBorderDecorator(true);
            c.setMode(mode);
            return c;
        }
        return new HiddenTagConverter(element, this._labelProvider);
    }

    private static Image getJSPSharedImage(String tagName) {
        Image image = PDPlugin.getDefault().getImage("palette/JSP/small/JSP_" + tagName.toUpperCase() + ".gif");
        return image;
    }

    public String getSupportedURI() {
        return "jsp";
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ITagConverter) {
                Element hostElement = ((ITagConverter)element).getHostElement();
                String tagName = hostElement.getLocalName();
                return JSPConverterFactory.getJSPSharedImage(tagName);
            }
            return null;
        }
    }
}

