/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.FlowUtilities;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.layout.TextFragmentBox;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TextLayoutSupport {
    private static final Logger _log = PDPlugin.getLogger(TextLayoutSupport.class);
    private static final String[] DELIMITERS = new String[]{"\r\n", "\n", "\r"};
    private static int delimeterLength;

    protected static TextFragmentBox getFragment(int i, List fragments) {
        if (fragments.size() > i) {
            return (TextFragmentBox)fragments.get(i);
        }
        TextFragmentBox box = new TextFragmentBox();
        fragments.add(box);
        return box;
    }

    public static float getAverageCharWidth(TextFragmentBox fragment) {
        if (fragment._width != 0 && fragment._length != 0) {
            return (float)fragment._width / (float)fragment._length;
        }
        return 0.0f;
    }

    public static void layoutNormal(FlowContext context, String text, List fragments, Font font, int wrappingStyle, boolean trimLeading) {
        int i = 0;
        int offset = 0;
        if (trimLeading) {
            offset = 1;
            text = text.substring(1);
        }
        int length = 0;
        while (text.length() > 0) {
            TextFragmentBox fragment = null;
            float prevAvgCharWidth = 0.0f;
            fragment = TextLayoutSupport.getFragment(i, fragments);
            prevAvgCharWidth = TextLayoutSupport.getAverageCharWidth(fragment);
            if (i != 0) {
                boolean changed = false;
                if (text.charAt(0) == '\r') {
                    text = text.substring(1);
                    changed = true;
                    ++offset;
                }
                if (text.length() != 0 && text.charAt(0) == '\n') {
                    text = text.substring(1);
                    changed = true;
                    ++offset;
                }
                if (changed) {
                    context.endLine();
                }
            }
            fragment._offset = offset;
            while (true) {
                LineBox currentLine = context.getCurrentLine();
                length = FlowUtilities.setupFragmentBasedOnTextSpace(fragment, text, font, currentLine.getAvailableWidth(), prevAvgCharWidth, wrappingStyle);
                if (fragment._width <= currentLine.getAvailableWidth() || !context.isCurrentLineOccupied()) break;
                context.endLine();
            }
            context.addToCurrentLine(fragment);
            text = text.substring(length);
            offset += length;
            if (text.length() > 0) {
                context.endLine();
            }
            ++i;
        }
        while (i < fragments.size()) {
            fragments.remove(fragments.size() - 1);
        }
    }

    public static void layoutNoWrap(FlowContext context, String text, List fragments, Font font) {
        int i = 0;
        int offset = 0;
        while (offset < text.length()) {
            int result = TextLayoutSupport.nextLineBreak(text, offset);
            TextFragmentBox fragment = TextLayoutSupport.getFragment(i++, fragments);
            fragment._length = result - offset;
            fragment._offset = offset;
            FlowUtilities.setupFragment(fragment, font, text.substring(offset));
            context.getCurrentLine().add(fragment);
            offset = result + delimeterLength;
            if (delimeterLength == 0) continue;
            context.endLine();
        }
        while (i < fragments.size()) {
            fragments.remove(i++);
        }
    }

    private static int nextLineBreak(String text, int offset) {
        int result = text.length();
        delimeterLength = 0;
        int i = 0;
        while (i < DELIMITERS.length) {
            int current = text.indexOf(DELIMITERS[i], offset);
            if (current != -1 && current < result) {
                result = current;
                delimeterLength = DELIMITERS[i].length();
            }
            ++i;
        }
        return result;
    }

    public static void paintTextFigure(Graphics g, List fragments, Font font, int textDecoration) {
        TextLayoutSupport.paintTextFigure(g, fragments, font, null, textDecoration);
    }

    public static void paintTextDecoration(Graphics g, Rectangle rect, int textDecoration) {
        if ((textDecoration & 1) != 0) {
            g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        }
        if ((textDecoration & 2) != 0) {
            g.drawLine(rect.x, rect.y + 1, rect.x + rect.width - 1, rect.y + 1);
        }
        if ((textDecoration & 4) != 0) {
            g.drawLine(rect.x, rect.y + rect.height / 2, rect.x + rect.width - 1, rect.y + rect.height / 2);
        }
    }

    public static void paintTextFigure(Graphics g, List fragments, Font font, Color color, int textDecoration) {
        try {
            g.setFont(font);
            int i = 0;
            while (i < fragments.size()) {
                TextFragmentBox frag = (TextFragmentBox)fragments.get(i);
                String draw = frag.getTextData();
                if (color != null) {
                    g.setForegroundColor(color);
                }
                g.drawText(draw, frag._x, frag._y);
                if ((textDecoration & 1) != 0) {
                    g.drawLine(frag._x, frag._y + frag.getHeight() - 1, frag._x + frag.getWidth(), frag._y + frag.getHeight() - 1);
                }
                if ((textDecoration & 2) != 0) {
                    g.drawLine(frag._x, frag._y, frag._x + frag.getWidth(), frag._y);
                }
                if ((textDecoration & 4) != 0) {
                    g.drawLine(frag._x, frag._y + frag.getHeight() / 2, frag._x + frag.getWidth(), frag._y + frag.getHeight() / 2);
                }
                ++i;
            }
        }
        catch (Exception e) {
            _log.info("TextLayoutSupport.Info.1", (Throwable)e);
        }
    }

    public static void paintTextFigureWithSelection(Graphics g, List fragments, String text, Font font, Color color, int textDecoration, int start, int end, Color selectionForeColor, Color selectionBackColor) {
        try {
            Color originalForeground = g.getForegroundColor();
            Color originalBackgroud = g.getBackgroundColor();
            g.setFont(font);
            int i = 0;
            int n = fragments.size();
            while (i < n) {
                TextFragmentBox frag = (TextFragmentBox)fragments.get(i);
                if (color != null) {
                    g.setForegroundColor(color);
                }
                String draw = frag.getTextData();
                if (frag._offset >= end || frag._offset + frag._length <= start) {
                    g.drawText(draw, frag._x, frag._y);
                    TextLayoutSupport.paintTextDecoration(g, frag.getRectangle(), textDecoration);
                } else if (frag._offset >= start && frag._offset + frag._length <= end) {
                    g.setForegroundColor(selectionForeColor);
                    g.setBackgroundColor(selectionBackColor);
                    g.fillRectangle(frag._x, frag._y, FlowUtilities.getTextExtents((String)draw, (Font)font).width, frag.getHeight());
                    g.drawText(draw, frag._x, frag._y);
                    TextLayoutSupport.paintTextDecoration(g, frag.getRectangle(), textDecoration);
                } else {
                    g.drawText(draw, frag._x, frag._y);
                    g.setForegroundColor(selectionForeColor);
                    g.setBackgroundColor(selectionBackColor);
                    int partialStart = frag._offset > start ? frag._offset : start;
                    int partialEnd = frag._offset + frag._length > end ? end : frag._offset + frag._length;
                    int x = 0;
                    String skip = text.substring(frag._offset, partialStart);
                    x = FlowUtilities.getTextExtents((String)skip, (Font)font).width;
                    String todraw = text.substring(partialStart, partialEnd);
                    if (todraw.length() > 0) {
                        Dimension dimension = FlowUtilities.getTextExtents((String)(String.valueOf(skip) + todraw), (Font)font);
                        g.fillRectangle(frag._x + x, frag._y, dimension.width - x, dimension.height);
                        g.drawText(String.valueOf(skip) + todraw, frag._x, frag._y);
                        if (color != null) {
                            g.setForegroundColor(color);
                        } else {
                            g.setForegroundColor(originalForeground);
                        }
                        g.drawText(skip, frag._x, frag._y);
                        TextLayoutSupport.paintTextDecoration(g, frag.getRectangle(), textDecoration);
                        g.setForegroundColor(selectionForeColor);
                        TextLayoutSupport.paintTextDecoration(g, new Rectangle(frag._x + x, frag._y, dimension.width - x, dimension.height), textDecoration);
                    }
                }
                g.setForegroundColor(originalForeground);
                g.setBackgroundColor(originalBackgroud);
                ++i;
            }
        }
        catch (Exception e) {
            _log.info("TextLayoutSupport.Info.1", (Throwable)e);
        }
    }

    public static int getBeginX(Object textAlign, Rectangle rect, int textWidth) {
        int x = rect.x;
        if (textAlign != null) {
            String align = textAlign.toString();
            if ("left".equalsIgnoreCase(align)) {
                x = rect.x + 1;
            } else if ("right".equalsIgnoreCase(align)) {
                x = rect.x + rect.width - textWidth - 1;
                if (x < 1) {
                    x = 1;
                }
            } else if ("center".equalsIgnoreCase(align)) {
                int offset = (rect.width - textWidth) / 2;
                if (offset <= 0) {
                    offset = 0;
                }
                x = x + offset + 1;
            }
        }
        return x;
    }
}

