/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jst.pagedesigner.commands.PaletteDropInsertCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorDropTargetAdapter;

public class DesignerSourceMouseTrackAdapter
extends ExtendedEditorDropTargetAdapter
implements MouseListener,
MouseMoveListener {
    private int _location;
    private StructuredTextEditor _textEditor;
    private EditDomain _domain;

    public DesignerSourceMouseTrackAdapter(StructuredTextEditor textEditor, EditDomain domain) {
        super(false);
        this._textEditor = textEditor;
        this._domain = domain;
    }

    public void mouseMove(MouseEvent event) {
        Object object = this.getPaletteObject();
        StyledText text = null;
        if (this._textEditor.getTextViewer() == null) {
            return;
        }
        text = this._textEditor.getTextViewer().getTextWidget();
        if (object == null) {
            text.setCursor(null);
            return;
        }
        Point p = new Point(event.x, event.y);
        p = this._textEditor.getTextViewer().getTextWidget().toDisplay(p);
        SourceViewerDragDropHelper.getInstance().updateCaret(this._textEditor, p);
        this._location = text.getCaretOffset();
        this._location = SourceViewerDragDropHelper.getInstance().getValidLocation(this._textEditor, this._location);
        this._location = SourceViewerDragDropHelper.getInstance().showCaret(this._textEditor, this._location);
    }

    public void mouseUp(MouseEvent event) {
        if (event.button != 1) {
            if (this._domain.getPaletteViewer() != null) {
                this._domain.getPaletteViewer().setActiveTool(null);
            }
            return;
        }
        PaletteDropInsertCommand command = this.getCommand(event);
        if (command != null) {
            command.execute();
            this.resetPalette();
        }
        this._location = 0;
    }

    public Object getPaletteObject() {
        ToolEntry tool;
        if (this._domain.getPaletteViewer() != null && (tool = this._domain.getPaletteViewer().getActiveTool()) instanceof TagToolPaletteEntry) {
            return tool;
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    private PaletteDropInsertCommand getCommand(MouseEvent event) {
        Object data = this.getPaletteObject();
        PaletteDropInsertCommand command = null;
        if (data instanceof TagToolPaletteEntry) {
            TagToolPaletteEntry descriptor = (TagToolPaletteEntry)((Object)data);
            command = new PaletteDropInsertCommand(PageDesignerResources.getInstance().getString("DesignerSourceDropTargetListener.InserCommandLabel"), this._textEditor, descriptor, this._location);
        }
        return command;
    }

    private void resetPalette() {
        ToolEntry tool;
        if (this._domain.getPaletteViewer() != null && (tool = this._domain.getPaletteViewer().getPaletteRoot().getDefaultEntry()) != null) {
            this._domain.getPaletteViewer().setActiveTool(tool);
        }
    }
}

