/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizationsHelper;
import org.eclipse.jst.pagedesigner.editors.palette.IEntryChangeListener;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteConstants;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteHelper;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

public class PaletteItemManager
implements IPaletteItemManager,
IPaletteConstants {
    private static Map _managers = new HashMap();
    private List _categories = new ArrayList();
    private IProject _curProject = null;
    private IEntryChangeListener[] _listeners;
    private static PaletteItemManager _defaultManager = null;
    private static PaletteItemManager _currentInstance;

    public static synchronized PaletteItemManager getInstance(IProject project) {
        if (project == null) {
            return PaletteItemManager.getDefaultPaletteItemManager();
        }
        PaletteItemManager manager = (PaletteItemManager)_managers.get(project);
        if (manager == null) {
            manager = new PaletteItemManager(project);
            _managers.put(project, manager);
        }
        _currentInstance = manager;
        return manager;
    }

    public static synchronized PaletteItemManager getCurrentInstance() {
        return _currentInstance != null ? _currentInstance : null;
    }

    private IProject getCurProject() {
        return this._curProject;
    }

    public static synchronized void removePaletteItemManager(PaletteItemManager manager) {
        _managers.remove(manager.getCurProject());
    }

    public static synchronized void clearPaletteItemManager() {
        _managers.clear();
    }

    private static PaletteItemManager getDefaultPaletteItemManager() {
        if (_defaultManager == null) {
            _defaultManager = new PaletteItemManager(null);
        }
        return _defaultManager;
    }

    private PaletteItemManager(IProject project) {
        this._curProject = project;
        this.init();
    }

    public List getAllCategories() {
        if (this._categories == null) {
            this._categories = new ArrayList();
        }
        return this._categories;
    }

    protected synchronized void init() {
        this.getAllCategories().clear();
        this.initFromProject(this._curProject);
        DesignerPaletteCustomizationsHelper.loadUserCustomizations(this);
        this.sortCategories();
    }

    private void sortCategories() {
        Collections.sort(this.getAllCategories(), new Comparator(){

            public int compare(Object o1, Object o2) {
                String label1 = ((PaletteEntry)o1).getLabel();
                String label2 = ((PaletteEntry)o2).getLabel();
                return label1.compareTo(label2);
            }
        });
    }

    public void reset() {
        this.init();
        this.fireModelChanged(null, null);
    }

    private void initFromProject(IProject project) {
        this.registerHTMLCategory();
        this.registerJSPCategory();
        this.registerTldFromClasspath(project);
    }

    private void registerHTMLCategory() {
        PaletteHelper.configPaletteItemsByTLD(this, this.getCurProject(), HTMLCMDocumentFactory.getCMDocument((String)"HTML"));
    }

    private void registerJSPCategory() {
        PaletteHelper.configPaletteItemsByTLD(this, this.getCurProject(), HTMLCMDocumentFactory.getCMDocument((String)"JSP11"));
    }

    private void registerTldFromClasspath(IProject project) {
        ITaglibRecord[] tldrecs = TaglibIndex.getAvailableTaglibRecords((IPath)project.getFullPath());
        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
        int i = 0;
        while (i < tldrecs.length) {
            TLDDocument doc = (TLDDocument)factory.createCMDocument(tldrecs[i]);
            PaletteHelper.configPaletteItemsByTLD(this, this.getCurProject(), (CMDocument)doc);
            ++i;
        }
    }

    public TaglibPaletteDrawer findOrCreateCategory(String id, String label) {
        TaglibPaletteDrawer category2;
        for (TaglibPaletteDrawer category2 : this.getAllCategories()) {
            if (!id.equals(category2.getId())) continue;
            return category2;
        }
        category2 = this.createTaglibPaletteDrawer(id, label);
        return category2;
    }

    public TaglibPaletteDrawer findCategoryByURI(String uri) {
        for (TaglibPaletteDrawer category : this.getAllCategories()) {
            if (!uri.equals(category.getURI())) continue;
            return category;
        }
        return null;
    }

    public TaglibPaletteDrawer createTaglibPaletteDrawer(String uri, String label) {
        TaglibPaletteDrawer r = new TaglibPaletteDrawer(uri, label);
        this.getAllCategories().add(r);
        return r;
    }

    public TaglibPaletteDrawer getTaglibPalletteDrawer(String uri) {
        for (TaglibPaletteDrawer cat : this.getAllCategories()) {
            if (!uri.equals(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    public void addEntryChangeListener(IEntryChangeListener listener) {
        if (this._listeners == null) {
            this._listeners = new IEntryChangeListener[]{listener};
        } else {
            IEntryChangeListener[] newListeners = new IEntryChangeListener[this._listeners.length + 1];
            newListeners[0] = listener;
            System.arraycopy(this._listeners, 0, newListeners, 1, this._listeners.length);
            this._listeners = newListeners;
        }
    }

    public void removeEntryChangeListener(IEntryChangeListener listener) {
        if (this._listeners == null) {
            return;
        }
        if (this._listeners.length == 1) {
            this._listeners = null;
        } else {
            ArrayList newListenersList = new ArrayList(Arrays.asList(this._listeners));
            newListenersList.remove(listener);
            IEntryChangeListener[] newListeners = new IEntryChangeListener[newListenersList.size() - 1];
            newListeners = newListenersList.toArray(newListeners);
            this._listeners = newListeners;
        }
    }

    private void fireModelChanged(List oldDefinitions, List newDefinitions) {
        if (this._listeners == null) {
            return;
        }
        int i = 0;
        while (i < this._listeners.length) {
            this._listeners[i].modelChanged(oldDefinitions, newDefinitions);
            ++i;
        }
    }

    public IProject getProject() {
        return this.getCurProject();
    }

    public static void notifyPaletteItemManagersOfCustomizationsUpdate(IPaletteItemManager notifyingManager) {
        for (PaletteItemManager mgr : _managers.values()) {
            if (mgr == null || notifyingManager == mgr) continue;
            mgr.reset();
        }
    }
}

