/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableLayout2;

public class ColumnHelper {
    public static Rectangle getAdjustedColumnBoundingRectangle(GraphicalEditPart editPart) {
        CSSFigure cssFigure;
        LayoutManager layoutManager;
        IFigure figure;
        Rectangle bounds = editPart.getFigure().getBounds().getCopy();
        if (editPart.getParent() != null && (figure = ((GraphicalEditPart)editPart.getParent()).getFigure()) instanceof CSSFigure && (layoutManager = (cssFigure = (CSSFigure)figure).getLayoutManager()) instanceof CSSTableLayout2) {
            CSSTableLayout2 tableLayout = (CSSTableLayout2)layoutManager;
            bounds.y = tableLayout.getHSpacing();
            bounds.height = figure.getClientArea().height - tableLayout.getHSpacing() * 2;
        }
        bounds = new PrecisionRectangle(bounds.getResized(-1, -1));
        editPart.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static Rectangle getColumnBounds(GraphicalEditPart editPart, IFigure target) {
        Rectangle bounds = ColumnHelper.getAdjustedColumnBoundingRectangle(editPart);
        target.translateToRelative((Translatable)bounds);
        Insets insets = target.getInsets();
        bounds.translate(-insets.left, -insets.top);
        bounds.resize(insets.getWidth() + 1, insets.getHeight() + 1);
        return bounds;
    }
}

