/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.meta.internal;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.meta.ICMRegistry;
import org.eclipse.jst.pagedesigner.meta.IElementDescriptor;
import org.eclipse.jst.pagedesigner.meta.internal.ElementDescReader;
import org.eclipse.jst.pagedesigner.meta.internal.SimpleCMRegistry;
import org.osgi.framework.Bundle;

public class CMRegistry
implements ICMRegistry {
    static Logger _log = PDPlugin.getLogger(CMRegistry.class);
    private Map _htmlMap = new HashMap();
    private Map _jspMap = new HashMap();
    private List _contributedRegistries = new ArrayList();
    private static CMRegistry _instance = null;

    public static ICMRegistry getInstance() {
        if (_instance == null) {
            _instance = new CMRegistry();
        }
        return _instance;
    }

    private CMRegistry() {
        ProgressMonitorDialog progress = new ProgressMonitorDialog(null);
        try {
            progress.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        monitor.beginTask(PDPlugin.getResourceString("CMRegistry.ReadConfigration"), -1);
                        monitor.subTask(PDPlugin.getResourceString("CMRegistry.HTMLConfigration"));
                        CMRegistry.this.loadCM("configs/cm/html.xml", CMRegistry.this._htmlMap);
                        monitor.subTask(PDPlugin.getResourceString("CMRegistry.JSPConfigration"));
                        CMRegistry.this.loadCM("configs/cm/jsp.xml", CMRegistry.this._jspMap);
                        monitor.subTask(PDPlugin.getResourceString("CMRegistry.OtherConfigration"));
                        CMRegistry.this.readExtensions();
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private void readExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "cmRegistry");
        IConfigurationElement[] eles = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < eles.length) {
            String uri;
            if (eles[i].getName().equals("registry") && (uri = eles[i].getAttribute("uri")) != null && uri.length() != 0) {
                String className;
                String configFile = eles[i].getAttribute("configFile");
                if (configFile != null && configFile.length() > 0) {
                    String bundleName = eles[i].getDeclaringExtension().getContributor().getName();
                    try {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        URL cmFileUrl = bundle.getEntry(configFile);
                        SimpleCMRegistry reg = new SimpleCMRegistry(uri, cmFileUrl);
                        this._contributedRegistries.add(reg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if ((className = eles[i].getAttribute("class")) != null && className.length() > 0) {
                    try {
                        Object obj = eles[i].createExecutableExtension("class");
                        if (obj instanceof ICMRegistry) {
                            this._contributedRegistries.add(obj);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public String getSupportedURI() {
        return null;
    }

    private void loadCM(String fileName, Map map) {
        try {
            URL url = PDPlugin.getDefault().getBundle().getEntry(fileName);
            ElementDescReader reader = new ElementDescReader(url);
            reader.readElements(map);
        }
        catch (Exception e) {
            _log.error("Error loading " + fileName + ": " + e.getMessage());
        }
    }

    public IElementDescriptor getElementDescriptor(String uri, String tagname) {
        IElementDescriptor desc;
        if (uri == null) {
            uri = "html";
        }
        if ("html".equals(uri) && (desc = this.getHTMLElementDescriptor(tagname)) != null) {
            return desc;
        }
        if ("jsp".equals(uri)) {
            return this.getJSPElementDescriptor(tagname);
        }
        int i = 0;
        int size = this._contributedRegistries.size();
        while (i < size) {
            IElementDescriptor ret;
            ICMRegistry reg = (ICMRegistry)this._contributedRegistries.get(i);
            if (uri.equals(reg.getSupportedURI()) && (ret = reg.getElementDescriptor(uri, tagname)) != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    private IElementDescriptor getHTMLElementDescriptor(String tagname) {
        return (IElementDescriptor)this._htmlMap.get(tagname.toLowerCase());
    }

    private IElementDescriptor getJSPElementDescriptor(String tagname) {
        return (IElementDescriptor)this._jspMap.get(tagname.toLowerCase());
    }
}

