/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.CommonResourceDialog;
import org.eclipse.jst.jsf.common.ui.internal.utils.PathUtil;
import org.eclipse.jst.jsf.common.ui.internal.utils.WebrootUtil;
import org.eclipse.jst.pagedesigner.properties.celleditors.EditableDialogCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.ResourceBoundle;
import org.eclipse.jst.pagedesigner.utils.WebAppUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ResourceDialogCellEditor
extends EditableDialogCellEditor {
    private IProject _project;
    private String[] _suffixs;
    private String _resourceDescription;
    private IFile _referredFile;
    private boolean _isWebPath = false;
    private boolean _needTransformJSPURL = true;
    private String _separator = "";

    public ResourceDialogCellEditor() {
    }

    public ResourceDialogCellEditor(Composite parent) {
        super(parent);
    }

    public ResourceDialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Shell shell = cellEditorWindow.getShell();
        int style = "".equals(this._separator) ? 0 : 770;
        CommonResourceDialog dialog = new CommonResourceDialog(shell, this._project, style);
        dialog.setTitle(ResourceBoundle.getString("FileCellEditor.Title"));
        dialog.setSuffixs(this._suffixs);
        dialog.setResourceDescription(this._resourceDescription);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < result.length) {
                IPath path = ((IFile)result[i]).getLocation();
                IPath referredPath = null;
                referredPath = this._referredFile != null ? this._referredFile.getLocation() : this._project.getLocation();
                String newValue = null;
                if (this._isWebPath) {
                    IFile selectedFile = (IFile)result[i];
                    newValue = WebrootUtil.getWebPath((IPath)selectedFile.getFullPath());
                } else {
                    newValue = PathUtil.convertToRelativePath((String)path.toString(), (String)referredPath.toString());
                }
                if (this._needTransformJSPURL) {
                    newValue = WebAppUtil.transformJSPURL(newValue, this._referredFile);
                }
                buffer.append(newValue);
                buffer.append(this._separator);
                ++i;
            }
            if (buffer.length() > 0) {
                return buffer.substring(0, buffer.length() - this._separator.length());
            }
        }
        return null;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    public IProject getProject() {
        return this._project;
    }

    public IFile getReferredFile() {
        return this._referredFile;
    }

    public void setReferredFile(IFile referredFile) {
        this._referredFile = referredFile;
    }

    public String getResourceDescription() {
        return this._resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this._resourceDescription = resourceDescription;
    }

    public String[] getSuffixs() {
        return this._suffixs;
    }

    public void setSuffixs(String[] suffixs) {
        this._suffixs = suffixs;
    }

    public void setWebPath(boolean isWebPath) {
        this._isWebPath = isWebPath;
    }

    public void setTransformJSPURL(boolean needTransform) {
        this._needTransformJSPURL = needTransform;
    }

    public String getSeparator() {
        return this._separator;
    }

    public void setSeparator(String separator) {
        this._separator = separator;
    }
}

