/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogfields;

import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringButtonDialogField;
import org.eclipse.jst.pagedesigner.commands.single.ChangeStyleCommand;
import org.eclipse.jst.pagedesigner.properties.attrgroup.IElementContextable;
import org.eclipse.jst.pagedesigner.ui.dialogs.DialogsMessages;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class StyleButtonDialogField
extends StringButtonDialogField
implements IElementContextable {
    private IDOMElement _element;

    public StyleButtonDialogField() {
        this(null);
    }

    public StyleButtonDialogField(IDOMElement element) {
        this(null, element);
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                StyleButtonDialogField.this.browseButtonPressed();
            }
        });
        this.setButtonLabel(DialogsMessages.getString("StyleButtonDialogField.Edit"));
    }

    public StyleButtonDialogField(IStringButtonAdapter adapter, IDOMElement element) {
        super(adapter);
        this._element = element;
    }

    public void setElementContext(IDOMNode ancester, IDOMElement element) {
        this._element = element;
    }

    private void browseButtonPressed() {
        if (this._element instanceof ElementCSSInlineStyle) {
            CSSPropertyContext context;
            ICSSStyleDeclaration styleDeclaration = (ICSSStyleDeclaration)((ElementCSSInlineStyle)this._element).getStyle();
            PreferenceManager manager = new PreferenceManager();
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            StyleDialog dialog = new StyleDialog(shell, manager, this._element, context = new CSSPropertyContext(styleDeclaration));
            if (dialog.open() == 0) {
                if (!context.isModified()) {
                    return;
                }
                ChangeStyleCommand c = new ChangeStyleCommand(this._element, context);
                c.execute();
                String style = this._element == null ? null : this._element.getAttribute("style");
                this.setText(style);
            }
        }
    }

    public void setElement(IDOMElement element) {
        this._element = element;
    }
}

