/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.core.internal.RuntimeComponentProviderDelegate;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Runtime;

public class JRERuntimeComponentProvider
extends RuntimeComponentProviderDelegate {
    public static final String CLASSPATH = "classpath";
    private Map vmCache = new HashMap();
    static /* synthetic */ Class class$0;

    public List getRuntimeComponents(IRuntime runtime) {
        IJavaRuntime javaRuntime;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IJavaRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaRuntime = (IJavaRuntime)runtime.loadAdapter((Class)clazz, null)) != null) {
            VMInstallCache cache = (VMInstallCache)this.vmCache.get(runtime.getId());
            if (cache != null) {
                if (cache.timestamp != ((Runtime)runtime).getTimestamp()) {
                    cache = null;
                }
                if (cache != null && cache.location != null && cache.vmInstall != null && !cache.location.equals(cache.vmInstall.getInstallLocation())) {
                    cache = null;
                }
            }
            if (cache == null) {
                cache = new VMInstallCache();
                cache.timestamp = ((Runtime)runtime).getTimestamp();
                cache.vmInstall = javaRuntime.getVMInstall();
                if (cache.vmInstall != null) {
                    IVMInstall2 vmInstall2;
                    if (cache.vmInstall instanceof IVMInstall2 && (vmInstall2 = (IVMInstall2)cache.vmInstall) != null) {
                        cache.jvmver = vmInstall2.getJavaVersion();
                    }
                    cache.location = cache.vmInstall.getInstallLocation();
                }
                this.vmCache.put(runtime.getId(), cache);
            }
            IVMInstall vmInstall = cache.vmInstall;
            String jvmver = cache.jvmver;
            String vmInstallName = vmInstall != null ? vmInstall.getName() : "Unknown";
            IRuntimeComponentVersion rcv = null;
            if (vmInstall == null) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            } else if (jvmver == null) {
                Trace.trace((byte)1, "Could not determine VM version for: " + vmInstallName);
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            } else if (jvmver.startsWith("1.3")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.3");
            } else if (jvmver.startsWith("1.4")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.4");
            } else if (jvmver.startsWith("1.5") || jvmver.startsWith("5.0")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("5.0");
            } else if (jvmver.startsWith("1.6") || jvmver.startsWith("6.0")) {
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            } else {
                Trace.trace((byte)1, "Invalid Java version: " + vmInstallName + ", " + jvmver);
                rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
            }
            if (rcv != null) {
                HashMap<String, String> properties = new HashMap<String, String>(3);
                String name = "-";
                if (vmInstallName != null) {
                    name = vmInstallName;
                }
                properties.put("name", name);
                StringBuffer buf = new StringBuffer();
                buf.append("JRE ");
                buf.append(rcv.getVersionString());
                buf.append(": ");
                buf.append(name);
                properties.put("type", buf.toString());
                if (vmInstall != null) {
                    if (vmInstall == null || javaRuntime.isUsingDefaultJRE()) {
                        properties.put(CLASSPATH, new Path(JavaRuntime.JRE_CONTAINER).toPortableString());
                    } else {
                        properties.put(CLASSPATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
                    }
                }
                ArrayList<IRuntimeComponent> list = new ArrayList<IRuntimeComponent>();
                list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rcv, properties));
                return list;
            }
        }
        return null;
    }

    class VMInstallCache {
        IVMInstall vmInstall;
        String jvmver;
        int timestamp;
        File location;

        VMInstallCache() {
        }
    }
}

