/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainer;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.core.internal.ServerProfiler;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.osgi.framework.BundleContext;

public class JavaServerPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.server.core";
    private static JavaServerPlugin singleton;
    private static List runtimeClasspathProviders;
    private static List serverProfilers;
    private static IRuntimeLifecycleListener runtimeListener;

    public JavaServerPlugin() {
        singleton = this;
    }

    public static JavaServerPlugin getInstance() {
        return singleton;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        runtimeListener = new IRuntimeLifecycleListener(){

            public void runtimeAdded(IRuntime runtime) {
                JavaServerPlugin.this.handleRuntimeChange(runtime, 0);
            }

            public void runtimeChanged(IRuntime runtime) {
                JavaServerPlugin.this.handleRuntimeChange(runtime, 1);
            }

            public void runtimeRemoved(IRuntime runtime) {
                JavaServerPlugin.this.handleRuntimeChange(runtime, 2);
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)runtimeListener);
    }

    public void stop(BundleContext context2) throws Exception {
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)runtimeListener);
        super.stop(context2);
    }

    protected void handleRuntimeChange(IRuntime runtime, int act) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        Trace.trace((byte)3, "Possible runtime change: " + runtime);
        if (runtime.getRuntimeType() == null) {
            return;
        }
        RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider(runtime.getRuntimeType());
        if (rcpw != null && (rcpw.hasRuntimeClasspathChanged(runtime) || act != 1)) {
            IPath serverContainerPath = new Path("org.eclipse.jst.server.core.container").append(rcpw.getId()).append(runtime.getId());
            class RebuildRuntimeReferencesJob
            extends Job {
                final /* synthetic */ JavaServerPlugin this$0;
                private final /* synthetic */ IPath val$serverContainerPath;
                private final /* synthetic */ IRuntime val$runtime;
                private final /* synthetic */ int val$act;
                private final /* synthetic */ RuntimeClasspathProviderWrapper val$rcpw;

                public RebuildRuntimeReferencesJob(JavaServerPlugin javaServerPlugin, IRuntime iRuntime, IPath iPath, int n, RuntimeClasspathProviderWrapper runtimeClasspathProviderWrapper) {
                    super(NLS.bind((String)Messages.updateClasspathContainers, (Object)iRuntime.getName()));
                    this.this$0 = javaServerPlugin;
                    this.val$runtime = iRuntime;
                    this.val$serverContainerPath = iPath;
                    this.val$act = n;
                    this.val$rcpw = runtimeClasspathProviderWrapper;
                }

                public boolean belongsTo(Object family) {
                    return ServerUtil.SERVER_JOB_FAMILY.equals(family);
                }

                public IStatus run(IProgressMonitor monitor) {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    if (projects != null) {
                        int size = projects.length;
                        int i = 0;
                        while (i < size) {
                            if (projects[i].isAccessible()) {
                                try {
                                    if (projects[i].isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                                        IJavaProject javaProject = JavaCore.create((IProject)projects[i]);
                                        boolean found = false;
                                        IClasspathEntry[] ce = javaProject.getRawClasspath();
                                        int j = 0;
                                        while (j < ce.length) {
                                            if (ce[j].getEntryKind() == 5 && this.val$serverContainerPath.isPrefixOf(ce[j].getPath())) {
                                                found = true;
                                            }
                                            ++j;
                                        }
                                        Trace.trace((byte)3, "Classpath change on: " + projects[i] + " " + found);
                                        if (found) {
                                            IRuntime runtime2 = this.val$runtime;
                                            if (this.val$act == 2) {
                                                runtime2 = null;
                                            }
                                            RuntimeClasspathContainer container = new RuntimeClasspathContainer(projects[i], this.val$serverContainerPath, this.val$rcpw, runtime2, this.val$runtime.getId());
                                            JavaCore.setClasspathContainer((IPath)this.val$serverContainerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Trace.trace((byte)2, "Could not update classpath container", e);
                                }
                            }
                            ++i;
                        }
                    }
                    return Status.OK_STATUS;
                }
            }
            RebuildRuntimeReferencesJob job = new RebuildRuntimeReferencesJob(this, runtime, serverContainerPath, act, rcpw);
            job.schedule();
        }
    }

    private static void log(IStatus status) {
        JavaServerPlugin.getInstance().getLog().log(status);
    }

    public static void logWarning(String msg) {
        JavaServerPlugin.log((IStatus)new Status(2, PLUGIN_ID, 0, msg, null));
    }

    public static RuntimeClasspathProviderWrapper[] getRuntimeClasspathProviders() {
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        RuntimeClasspathProviderWrapper[] rth = new RuntimeClasspathProviderWrapper[runtimeClasspathProviders.size()];
        runtimeClasspathProviders.toArray(rth);
        return rth;
    }

    public static RuntimeClasspathProviderWrapper findRuntimeClasspathProvider(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        Iterator iterator = runtimeClasspathProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeClasspathProviderWrapper runtimeClasspathProvider = (RuntimeClasspathProviderWrapper)iterator.next();
            if (!runtimeClasspathProvider.supportsRuntimeType(runtimeType)) continue;
            return runtimeClasspathProvider;
        }
        return null;
    }

    public static RuntimeClasspathProviderWrapper findRuntimeClasspathProviderBySupport(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        Iterator iterator = runtimeClasspathProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeClasspathProviderWrapper runtimeClasspathProvider = (RuntimeClasspathProviderWrapper)iterator.next();
            if (!runtimeClasspathProvider.supportsRuntimeType(id)) continue;
            return runtimeClasspathProvider;
        }
        return null;
    }

    public static RuntimeClasspathProviderWrapper findRuntimeClasspathProvider(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        Iterator iterator = runtimeClasspathProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeClasspathProviderWrapper runtimeClasspathProvider = (RuntimeClasspathProviderWrapper)iterator.next();
            if (!id.equals(runtimeClasspathProvider.getId())) continue;
            return runtimeClasspathProvider;
        }
        return null;
    }

    private static synchronized void loadRuntimeClasspathProviders() {
        if (runtimeClasspathProviders != null) {
            return;
        }
        Trace.trace((byte)0, "->- Loading .runtimeClasspathProviders extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "runtimeClasspathProviders");
        int size = cf.length;
        ArrayList<RuntimeClasspathProviderWrapper> list = new ArrayList<RuntimeClasspathProviderWrapper>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeClasspathProviderWrapper(cf[i]));
                Trace.trace((byte)0, "  Loaded runtimeClasspathProviders: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)2, "  Could not load runtimeClasspathProviders: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeClasspathProviders = list;
        Trace.trace((byte)0, "-<- Done loading .runtimeClasspathProviders extension point -<-");
    }

    public static ServerProfiler[] getServerProfilers() {
        if (serverProfilers == null) {
            JavaServerPlugin.loadServerProfilers();
        }
        ServerProfiler[] sp = new ServerProfiler[serverProfilers.size()];
        serverProfilers.toArray(sp);
        return sp;
    }

    private static synchronized void loadServerProfilers() {
        if (serverProfilers != null) {
            return;
        }
        Trace.trace((byte)0, "->- Loading .serverProfilers extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "serverProfilers");
        int size = cf.length;
        ArrayList<ServerProfiler> list = new ArrayList<ServerProfiler>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ServerProfiler(cf[i]));
                Trace.trace((byte)0, "  Loaded serverProfiler: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)2, "  Could not load serverProfiler: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        serverProfilers = list;
        Trace.trace((byte)0, "-<- Done loading .serverProfilers extension point -<-");
    }

    public static void configureProfiling(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor) throws CoreException {
        ServerProfiler[] sp = JavaServerPlugin.getServerProfilers();
        if (sp == null || sp.length == 0) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 0, Messages.errorNoProfiler, null));
        }
        sp[0].process(launch, vmInstall, vmConfig, monitor);
    }
}

