/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;

public class TypeSelectionFilter2 {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";

    public String[] getWebServiceTypeByInitialSelection(IStructuredSelection initialSelection, ArrayList webServiceTypeList) {
        ArrayList<String> supportedTypes = new ArrayList<String>();
        if (initialSelection != null && initialSelection.size() == 1) {
            Object initialObject = initialSelection.getFirstElement();
            if (initialObject == null) {
                return null;
            }
            for (String wst : webServiceTypeList) {
                String scenario = wst.substring(0, wst.indexOf("/"));
                String implId = wst.substring(wst.indexOf("/") + 1);
                if (!scenario.equals(String.valueOf(0)) || supportedTypes.contains(wst)) continue;
                WebServiceImpl wsimpl = WebServiceRuntimeExtensionUtils2.getWebServiceImplById(implId);
                String[] resourceTypes = wsimpl.getResourceTypeMetadata();
                int i = 0;
                while (i < resourceTypes.length) {
                    if (resourceTypes[i] != null && initialObject.getClass().getName().endsWith(resourceTypes[i])) {
                        String name = null;
                        IResource resource = null;
                        try {
                            resource = ResourceUtils.getResourceFromSelection((Object)initialObject);
                        }
                        catch (CoreException coreException) {
                            resource = null;
                        }
                        name = resource instanceof IContainer ? initialObject.getClass().getName() : (resource != null ? resource.getFullPath().toString() : initialObject.getClass().getName());
                        String[] extensions = wsimpl.getExtensionMetadata();
                        if (this.acceptsName(name, extensions)) {
                            supportedTypes.add(wst);
                        }
                    }
                    ++i;
                }
                if (!supportedTypes.isEmpty() || !(initialObject instanceof BeanLink) && !(initialObject instanceof ServiceImplBean)) continue;
                supportedTypes.add(wst);
            }
            if (supportedTypes.isEmpty()) {
                String[] resourceTypes = new String[]{"File", "IResource", "String", "ServiceImpl", "ServiceRefImpl", "WSDLResourceImpl"};
                int i = 0;
                while (i < resourceTypes.length) {
                    if (resourceTypes[i] != null && initialObject.getClass().getName().endsWith(resourceTypes[i])) {
                        String name = null;
                        IResource resource = null;
                        try {
                            resource = ResourceUtils.getResourceFromSelection((Object)initialObject);
                        }
                        catch (CoreException coreException) {
                            resource = null;
                        }
                        name = resource instanceof IContainer ? initialObject.getClass().getName() : (resource != null ? resource.getFullPath().toString() : (initialObject instanceof String ? (String)initialObject : initialObject.getClass().getName()));
                        String[] extensions = new String[]{".wsdl", ".wsil", ".html", ".ServiceImpl", ".ServiceRefImpl", ".WSDLResourceImpl"};
                        if (this.acceptsName(name, extensions)) {
                            StringBuffer entrybuff = new StringBuffer();
                            entrybuff.append(String.valueOf(1));
                            entrybuff.append("/");
                            entrybuff.append("org.eclipse.jst.ws.wsImpl.java");
                            String entry = entrybuff.toString();
                            supportedTypes.add(entry);
                        }
                    }
                    ++i;
                }
            }
        }
        if (supportedTypes.isEmpty()) {
            return null;
        }
        return supportedTypes.toArray(new String[0]);
    }

    private boolean acceptsName(String name, String[] extensions) {
        if (extensions[0] != null && extensions[0].equals("all")) {
            return true;
        }
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i] != null && name.endsWith(extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

