/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class StyleDeclarationFormatter
extends DefaultCSSSourceFormatter {
    private static StyleDeclarationFormatter instance;

    StyleDeclarationFormatter() {
    }

    protected void formatBefore(ICSSNode node, ICSSNode child, String toAppend, StringBuffer source, IRegion exceptFor) {
        ITextRegion curReg;
        ICSSModel cssModel;
        IStructuredDocument structuredDocument;
        int end;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        ICSSNode prev = child != null ? child.getPreviousSibling() : node.getLastChild();
        int start = prev != null ? ((IndexedRegion)prev).getEndOffset() : 0;
        int n = end = child != null ? ((IndexedRegion)child).getStartOffset() : 0;
        if (child == null && prev == null) {
            return;
        }
        if (start > 0 && start < end) {
            IStructuredDocument structuredDocument2;
            ICSSModel cssModel2 = node.getOwnerDocument().getModel();
            if (cssModel2 != null && (structuredDocument2 = cssModel2.getStructuredDocument()) != null) {
                CompoundRegion[] regions = null;
                if (exceptFor == null) {
                    regions = this.getRegionsWithoutWhiteSpaces(structuredDocument2, new FormatRegion(start, end - start), stgy);
                } else {
                    String pickupType = "DECLARATION_DELIMITER";
                    if (prev == null || child == null) {
                        pickupType = null;
                    }
                    regions = this.getRegions(structuredDocument2, new FormatRegion(start, end - start), exceptFor, pickupType);
                }
                int i = 0;
                while (i < regions.length) {
                    this.appendSpaceBefore(node, regions[i], source);
                    source.append(this.decoratedRegion(regions[i], 0, stgy));
                    ++i;
                }
            }
        } else if (prev != null && child != null) {
            boolean semicolonFound = false;
            ICSSModel cssModel3 = node.getOwnerDocument().getModel();
            if (cssModel3 != null && (structuredDocument = cssModel3.getStructuredDocument()) != null) {
                int prevStart = prev != null ? ((IndexedRegion)prev).getStartOffset() : 0;
                int prevEnd = prev != null ? ((IndexedRegion)prev).getEndOffset() : 0;
                CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(prevStart, prevEnd - prevStart), stgy);
                int i = regions.length - 1;
                while (i >= 0 && !semicolonFound) {
                    if (regions[i].getType() == "DECLARATION_DELIMITER") {
                        semicolonFound = true;
                    }
                    --i;
                }
            }
            if (!semicolonFound) {
                source.append(";");
            }
        } else if (prev == null) {
            RegionIterator it = null;
            if (end > 0) {
                ICSSModel cssModel4 = node.getOwnerDocument().getModel();
                if (cssModel4 != null && (structuredDocument = cssModel4.getStructuredDocument()) != null) {
                    it = new RegionIterator(structuredDocument, end - 1);
                }
            } else {
                IStructuredDocument structuredDocument3;
                int pos = this.getChildInsertPos(node);
                if (pos >= 0 && (cssModel = node.getOwnerDocument().getModel()) != null && (structuredDocument3 = cssModel.getStructuredDocument()) != null) {
                    it = new RegionIterator(structuredDocument3, pos - 1);
                }
            }
            if (it != null) {
                int limit = ((IndexedRegion)(node.getParentNode() != null ? node.getParentNode() : node)).getStartOffset();
                while (it.hasPrev()) {
                    curReg = it.prev();
                    if (curReg.getType() == "LBRACE" || curReg.getType() == "DECLARATION_DELIMITER") break;
                    if (curReg.getType() != "S" && curReg.getType() != "COMMENT") {
                        source.append(";");
                    } else if (it.getStructuredDocumentRegion().getStartOffset(curReg) > limit) {
                        continue;
                    }
                    break;
                }
            }
        } else if (child == null) {
            RegionIterator it = null;
            if (start > 0) {
                ICSSModel cssModel5 = node.getOwnerDocument().getModel();
                if (cssModel5 != null && (structuredDocument = cssModel5.getStructuredDocument()) != null) {
                    it = new RegionIterator(structuredDocument, start);
                }
            } else {
                IStructuredDocument structuredDocument4;
                int pos = this.getChildInsertPos(node);
                if (pos >= 0 && (cssModel = node.getOwnerDocument().getModel()) != null && (structuredDocument4 = cssModel.getStructuredDocument()) != null) {
                    it = new RegionIterator(structuredDocument4, pos);
                }
            }
            if (it != null) {
                int limit = ((IndexedRegion)(node.getParentNode() != null ? node.getParentNode() : node)).getEndOffset();
                while (it.hasNext()) {
                    curReg = it.next();
                    if (curReg.getType() != "RBRACE" && curReg.getType() != "DECLARATION_DELIMITER") {
                        if (curReg.getType() != "S" && curReg.getType() != "COMMENT") {
                            source.append(";");
                        } else if (limit > it.getStructuredDocumentRegion().getEndOffset(curReg)) {
                            continue;
                        }
                    }
                    break;
                }
            }
        }
        if (child == null) {
            if (((IndexedRegion)node).getEndOffset() <= 0) {
                IStructuredDocument structuredDocument5;
                int pos = this.getChildInsertPos(node);
                CompoundRegion toAppendRegion = null;
                if (pos >= 0 && (cssModel = node.getOwnerDocument().getModel()) != null && (structuredDocument5 = cssModel.getStructuredDocument()) != null) {
                    IStructuredDocumentRegion flatNode = structuredDocument5.getRegionAtCharacterOffset(pos);
                    toAppendRegion = new CompoundRegion(flatNode, flatNode.getRegionAtCharacterOffset(pos));
                }
                this.appendDelimBefore(node.getParentNode(), toAppendRegion, source);
            }
        } else if (prev != null || ((IndexedRegion)node).getEndOffset() <= 0) {
            Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
            if (preferences.getBoolean("onePropertyPerLine") && (node.getOwnerDocument() != node || !preferences.getBoolean("prohibitWrapOnAttr"))) {
                this.appendDelimBefore(node, null, source);
            } else if (prev != null || node.getOwnerDocument() != node) {
                this.appendSpaceBefore(node, toAppend, source);
            }
        }
    }

    protected void formatBefore(ICSSNode node, ICSSNode child, IRegion region, String toAppend, StringBuffer source) {
        IStructuredDocument structuredDocument;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        ICSSModel cssModel = node.getOwnerDocument().getModel();
        if (cssModel != null && (structuredDocument = cssModel.getStructuredDocument()) != null) {
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
            CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
            int i = 0;
            while (i < regions.length) {
                if (i != 0 || StyleDeclarationFormatter.needS(outside[0])) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
            if (StyleDeclarationFormatter.needS(outside[1])) {
                if (((IndexedRegion)child).getStartOffset() == region.getOffset() + region.getLength() && preferences.getBoolean("onePropertyPerLine") && (node.getOwnerDocument() != node || !preferences.getBoolean("prohibitWrapOnAttr"))) {
                    this.appendDelimBefore(node, null, source);
                } else {
                    this.appendSpaceBefore(node, toAppend, source);
                }
            }
        }
    }

    public int getChildInsertPos(ICSSNode node) {
        if (node == null) {
            return -1;
        }
        int pos = super.getChildInsertPos(node);
        if (pos < 0) {
            CSSSourceGenerator formatter = this.getParentFormatter(node);
            return formatter != null ? formatter.getChildInsertPos(node.getParentNode()) : -1;
        }
        return pos;
    }

    public static synchronized StyleDeclarationFormatter getInstance() {
        if (instance == null) {
            instance = new StyleDeclarationFormatter();
        }
        return instance;
    }

    public int getLengthToReformatAfter(ICSSNode node, int insertPos) {
        if (node == null) {
            return 0;
        }
        IndexedRegion nnode = (IndexedRegion)node;
        if (insertPos < 0 || !nnode.contains(insertPos)) {
            CSSSourceGenerator pntFormatter;
            if (node.getParentNode() != null && nnode.getEndOffset() <= 0 && (pntFormatter = this.getParentFormatter(node)) != null) {
                return pntFormatter.getLengthToReformatAfter(node.getParentNode(), insertPos);
            }
            return 0;
        }
        return super.getLengthToReformatAfter(node, insertPos);
    }

    public int getLengthToReformatBefore(ICSSNode node, int insertPos) {
        if (node == null) {
            return 0;
        }
        IndexedRegion nnode = (IndexedRegion)node;
        if (insertPos <= 0 || !nnode.contains(insertPos - 1)) {
            CSSSourceGenerator pntFormatter;
            if (node.getParentNode() != null && nnode.getEndOffset() <= 0 && (pntFormatter = this.getParentFormatter(node)) != null) {
                return pntFormatter.getLengthToReformatBefore(node.getParentNode(), insertPos);
            }
            return 0;
        }
        return super.getLengthToReformatBefore(node, insertPos);
    }
}

