/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class SView
extends Canvas {
    protected Color focusColor;
    protected boolean mouseOver = false;
    protected boolean hasFocus = false;
    protected Color one;
    protected Color two;
    protected Color three;
    protected Color grone;
    protected Color grtwo;
    protected Color grthree;
    private Cursor cursor;

    public SView(Composite parent, int style) {
        super(parent, style);
        this.cursor = new Cursor((Device)parent.getDisplay(), 21);
        this.setCursor(this.cursor);
        this.one = new Color((Device)this.getDisplay(), 224, 244, 252);
        this.two = new Color((Device)this.getDisplay(), 178, 212, 247);
        this.three = new Color((Device)this.getDisplay(), 138, 185, 242);
        this.grone = new Color((Device)this.getDisplay(), 229, 255, 193);
        this.grtwo = new Color((Device)this.getDisplay(), 63, 214, 16);
        this.grthree = new Color((Device)this.getDisplay(), 21, 157, 4);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SView.this.paintControl(e);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                SView.this.mouseOver = true;
                SView.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                SView.this.mouseOver = false;
                SView.this.redraw();
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SView.this.redraw();
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail != 4) {
                    e.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SView.this.hasFocus = true;
                SView.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                SView.this.hasFocus = false;
                SView.this.redraw();
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    SView.this.notifyListeners(13);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SView.this.disposeImpl();
            }
        });
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
            }

            public void getDescription(AccessibleEvent e) {
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = SView.this.getBounds();
                Point pt = SView.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 35;
            }

            public void getState(AccessibleControlEvent e) {
            }
        });
    }

    protected void disposeImpl() {
        if (this.cursor != null) {
            this.cursor.dispose();
            this.cursor = null;
            this.one.dispose();
            this.two.dispose();
            this.three.dispose();
            this.grone.dispose();
            this.grtwo.dispose();
            this.grthree.dispose();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)listener);
    }

    protected void notifyListeners(int eventType) {
        Event event = new Event();
        event.type = eventType;
        event.widget = this;
        this.notifyListeners(eventType, event);
    }

    protected void paintRect(GC gc, int x, int y, Color a, Color b, Color c) {
        int[] nArray = new int[16];
        nArray[1] = 2;
        nArray[2] = 2;
        nArray[4] = 30;
        nArray[6] = 32;
        nArray[7] = 2;
        nArray[8] = 32;
        nArray[9] = 30;
        nArray[10] = 30;
        nArray[11] = 32;
        nArray[12] = 2;
        nArray[13] = 32;
        nArray[15] = 30;
        int[] p = nArray;
        int[] q = new int[p.length];
        int i = 0;
        while (i < p.length / 2) {
            q[i * 2] = p[i * 2] + x;
            q[i * 2 + 1] = p[i * 2 + 1] + y;
            ++i;
        }
        Region region = new Region((Device)this.getDisplay());
        region.add(q);
        gc.setClipping(region);
        gc.setBackground(a);
        gc.setForeground(b);
        gc.fillGradientRectangle(x, y, 32, 32, true);
        gc.setClipping(null);
        gc.setForeground(c);
        gc.drawPolygon(q);
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
        String st = "Tomcat Test Environment";
        Point stp = gc.stringExtent(st);
        gc.drawString(st, x + 16 - stp.x / 2, y + 32 + 2);
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Point s = this.getSize();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, s.x, s.y);
        this.paintRect(gc, 60, 0, this.one, this.two, this.three);
        this.paintRect(gc, 140, 0, this.grone, this.grtwo, this.grthree);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(200, 60);
    }
}

