/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.core.IFeature;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.extension.ExtensionUtility;
import org.eclipse.wst.server.ui.internal.wizard.ExtensionWizard;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.ExtensionWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.LicenseWizardFragment;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class ExtensionWizard
extends TaskWizard {
    public ExtensionWizard(String title, String message) {
        super(title, new WizardFragment(){

            protected void createChildFragments(List list) {
                list.add(new ExtensionWizardFragment());
                list.add(new LicenseWizardFragment());
                list.add(new WizardFragment(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void performFinish(IProgressMonitor monitor) throws CoreException {
                        IFeature is = (IFeature)this.getTaskModel().getObject("feature");
                        if (is != null) {
                            ExtensionWizard.install(is);
                        }
                    }
                });
            }
        });
    }

    public static void invalidateLicense(TaskModel taskModel) {
        IFeature ls;
        IFeature is = (IFeature)taskModel.getObject("feature");
        if (is == (ls = (IFeature)taskModel.getObject("license_server"))) {
            return;
        }
        taskModel.putObject("license", (Object)"unknown");
        taskModel.putObject("accept", null);
        taskModel.putObject("license_server", null);
    }

    public static void updateLicense(IWizardHandle wizard, final TaskModel taskModel) {
        IFeature ls;
        final IFeature feature = (IFeature)taskModel.getObject("feature");
        if (feature.equals(ls = (IFeature)taskModel.getObject("license_server"))) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                String license = "unknown";
                license = ExtensionUtility.getLicense(feature);
                if (license == null) {
                    license = "none";
                }
                taskModel.putObject("license", (Object)license);
                taskModel.putObject("license_server", (Object)feature);
            }
        };
        try {
            wizard.run(true, false, runnable);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error with runnable", e);
        }
    }

    protected static void install(final IFeature feature) {
        if (feature == null) {
            return;
        }
        final boolean[] b = new boolean[1];
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                String msg = NLS.bind((String)Messages.wizNewInstallableServerConfirm, (Object)feature.getLabel());
                b[0] = MessageDialog.openConfirm((Shell)display.getActiveShell(), (String)Messages.defaultDialogTitle, (String)msg);
            }
        });
        if (!b[0]) {
            return;
        }
        String name = NLS.bind((String)Messages.wizNewInstallableServerJob, (Object)feature.getLabel());
        Job job = new Job(name){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    ExtensionUtility.install(feature, monitor);
                    if (!monitor.isCanceled()) {
                        ExtensionWizard.promptRestart();
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void promptRestart() {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                if (MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)Messages.defaultDialogTitle, (String)Messages.wizNewInstallableServerRestart)) {
                    Thread t = new Thread(this, "Restart thread", display){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ Display val$display;
                        {
                            this.this$1 = var1_1;
                            this.val$display = display;
                        }

                        public void run() {
                            try {
                                7.sleep(1000L);
                            }
                            catch (Exception exception) {}
                            this.val$display.asyncExec(new Runnable(this){
                                final /* synthetic */ 7 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    PlatformUI.getWorkbench().restart();
                                }
                            });
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            }
        });
    }
}

