/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTypeComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class NewRuntimeComposite
extends Composite {
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected Button createServer;
    protected IRuntimeWorkingCopy runtime;
    protected Map cache = new HashMap();
    protected Map serverCache = new HashMap();
    protected TaskModel taskModel;
    protected IWizardHandle wizard;
    protected String type;
    protected String version;
    protected String runtimeTypeId;
    protected IServerType serverType;

    public NewRuntimeComposite(Composite parent, IWizardHandle wizard, TaskModel tm, String type, String version, String runtimeTypeId) {
        super(parent, 0);
        this.wizard = wizard;
        this.taskModel = tm;
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.createControl();
        wizard.setTitle(Messages.wizNewRuntimeTitle);
        wizard.setDescription(Messages.wizNewRuntimeDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("newServerWiz"));
    }

    public void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        this.setLayout((Layout)layout);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this, "org.eclipse.wst.server.ui.swnr0000");
        RuntimeTypeComposite comp = new RuntimeTypeComposite(this, true, new RuntimeTypeComposite.RuntimeTypeSelectionListener(){

            public void runtimeTypeSelected(IRuntimeType runtimeType) {
                NewRuntimeComposite.this.handleSelection(runtimeType);
            }
        }, this.type, this.version, this.runtimeTypeId);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        comp.setLayoutData(data);
        this.createServer = new Button((Composite)this, 32);
        this.createServer.setText(Messages.wizNewRuntimeCreateServer);
        this.createServer.setSelection(ServerUIPlugin.getPreferences().getCreateServerWithRuntime());
        this.createServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRuntimeComposite.this.handleServer();
                ServerUIPlugin.getPreferences().setCreateServerWithRuntime(NewRuntimeComposite.this.createServer.getSelection());
            }
        });
    }

    protected void handleSelection(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            this.runtime = null;
        } else {
            try {
                this.runtime = null;
                this.runtime = (IRuntimeWorkingCopy)this.cache.get(runtimeType);
            }
            catch (Exception exception) {}
            if (this.runtime == null) {
                try {
                    this.runtime = runtimeType.createRuntime(null, null);
                    ServerUtil.setRuntimeDefaultName((IRuntimeWorkingCopy)this.runtime);
                    if (this.runtime != null) {
                        this.cache.put(runtimeType, this.runtime);
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.serverType = NewRuntimeComposite.getCompatibleServerType(runtimeType);
        this.handleServer();
    }

    protected void handleServer() {
        boolean option = false;
        if (this.serverType != null && this.serverType.hasRuntime()) {
            option = true;
        }
        this.createServer.setVisible(option);
        if (option && this.createServer.getSelection()) {
            IServerWorkingCopy server = this.getServer();
            this.taskModel.putObject("server", (Object)server);
        } else {
            this.taskModel.putObject("server", null);
        }
        this.taskModel.putObject("runtime", (Object)this.runtime);
        this.wizard.update();
    }

    protected static IServerType getCompatibleServerType(IRuntimeType runtimeType) {
        ArrayList<IServerType> list = new ArrayList<IServerType>();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        int size = serverTypes.length;
        int i = 0;
        while (i < size) {
            IRuntimeType rt = serverTypes[i].getRuntimeType();
            if (rt != null && rt.equals(runtimeType)) {
                list.add(serverTypes[i]);
            }
            ++i;
        }
        if (list.size() == 1) {
            return (IServerType)list.get(0);
        }
        return null;
    }

    protected IServerWorkingCopy getServer() {
        if (this.serverType == null || this.runtime == null || !this.serverType.hasRuntime()) {
            return null;
        }
        IServerWorkingCopy server = (IServerWorkingCopy)this.serverCache.get(this.runtime);
        if (server != null) {
            return server;
        }
        try {
            server = this.serverType.createServer(null, null, (IRuntime)this.runtime, null);
            if (server != null) {
                server.setHost("localhost");
                ServerUtil.setServerDefaultName((IServerWorkingCopy)server);
                this.serverCache.put(this.runtime, server);
                return server;
            }
        }
        catch (CoreException ce) {
            Trace.trace((byte)3, "Error creating server", ce);
        }
        return null;
    }

    public IRuntimeWorkingCopy getRuntime() {
        return this.runtime;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Control[] c = this.getChildren();
        if (c != null) {
            int size = c.length;
            int i = 0;
            while (i < size) {
                if (c[i] != null) {
                    c[i].setVisible(visible);
                }
                ++i;
            }
        }
    }
}

