/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests.performance;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.eclipse.wst.xml.ui.tests.performance.BasicEditorTest;
import org.eclipse.wst.xml.ui.tests.performance.EditorTestHelper;

public class OpenEditorWithFoldingTest
extends BasicEditorTest {
    public OpenEditorWithFoldingTest() {
        this.ZIP_FILE_NAME = "folding-tests.zip";
        this.PROJECT_NAME = "folding-tests";
        this.FILE_NAME = "GolfCountryClub.xml";
    }

    protected void tearDown() throws Exception {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("foldingEnabled", false);
        super.tearDown();
    }

    protected void setUpPrefs() {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, false);
        store.setValue("foldingEnabled", true);
        IPreferenceStore editorsStore = EditorsUI.getPreferenceStore();
        editorsStore.setValue("quickdiff.quickDiff", false);
    }

    public void testOpenEditorSmall() {
        this.tagAsSummary("Open XML Editor Small Folding ON", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
        this.testOpenEditor(this.FILE_NAME, true);
        this.tagAsSummary("Open XML Editor Small Folding OFF", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
        this.testOpenEditor(this.FILE_NAME, false);
    }

    public void testOpenEditorMedium() {
        this.tagAsSummary("Open XML Editor Medium Folding ON", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
        this.testOpenEditor("GolfCountryClub1.xml", true);
        this.tagAsSummary("Open XML Editor Medium Folding OFF", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
        this.testOpenEditor("GolfCountryClub1.xml", false);
    }

    public void testOpenEditorLarge() {
        this.tagAsSummary("Open XML Editor Large Folding ON", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
        this.testOpenEditor("formatted-a-first1000.xml", true);
        this.tagAsSummary("Open XML Editor Large Folding OFF", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
        this.testOpenEditor("formatted-a-first1000.xml", false);
    }

    private void testOpenEditor(String filename, boolean foldingEnabled) {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("foldingEnabled", foldingEnabled);
        int iterations = 3;
        int i = 0;
        while (i < iterations) {
            this.openEditor((IPath)new Path("/" + this.PROJECT_NAME + "/" + filename));
            this.runEvents();
            EditorTestHelper.closeAllEditors();
            this.runEvents();
            ++i;
        }
        i = 0;
        while (i < iterations) {
            this.startMeasuring();
            this.openEditor((IPath)new Path("/" + this.PROJECT_NAME + "/" + filename));
            this.runEvents();
            this.stopMeasuring();
            EditorTestHelper.closeAllEditors();
            this.runEvents();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

