/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.InterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaWSDLMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapFactory;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapPackage;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResourceFactory;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddFactory;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class WebServicesEMFTest
extends GeneralEMFPopulationTest {
    public EARFile earFile;
    public EJBJarFile ejbFile;
    int currentVersion = 13;
    private int createdInterfaceMaps = 0;
    static /* synthetic */ Class class$0;

    public WebServicesEMFTest(String name) {
        super(name);
    }

    public WebServicesEMFTest(String name, RendererFactory factory) {
        super(name, factory);
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.WebServicesEMFTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite(RendererFactory factory) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.emftests.WebServicesEMFTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new WebServicesEMFTest("test13WebServicesClientPopulation", factory));
        suite.addTest((Test)new WebServicesEMFTest("test13WebServicesDDPopulation", factory));
        suite.addTest((Test)new WebServicesEMFTest("test14WebServicesDDPopulation", factory));
        suite.addTest((Test)new WebServicesEMFTest("testJaxRPCMapPopulation", factory));
        return suite;
    }

    public void test13WebServicesClientPopulation() throws Exception {
        this.currentVersion = 13;
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createEJB();
        WebServicesResource webserDD = (WebServicesResource)this.ejbFile.getResourceSet().createResource(URI.createURI((String)"META-INF/webservicesclient.xml"));
        webserDD.setVersionID(this.currentVersion);
        this.setVersion(1);
        this.populateRoot(webserDD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + this.getProjectLocation();
        this.earFile.extractTo(out, 126);
        this.earFile.close();
    }

    public void testJaxRPCMapPopulation() throws Exception {
        this.currentVersion = 13;
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createEJB();
        String mappingFilePathURI = "META-INF/testmap.xml";
        URI uri = URI.createURI((String)mappingFilePathURI);
        ResourceSet resSet = this.ejbFile.getResourceSet();
        J2EEResourceFactoryRegistry registry = (J2EEResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        registry.registerLastFileSegment(uri.lastSegment(), (Resource.Factory)new JaxrpcmapResourceFactory(RendererFactory.getDefaultRendererFactory()));
        resSet = this.earFile.getResourceSet();
        registry = (J2EEResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        registry.registerLastFileSegment(uri.lastSegment(), (Resource.Factory)new JaxrpcmapResourceFactory(RendererFactory.getDefaultRendererFactory()));
        JaxrpcmapResource jaxrpcmapRes = (JaxrpcmapResource)resSet.createResource(uri);
        jaxrpcmapRes.setVersionID(this.currentVersion);
        this.setVersion(1);
        JavaWSDLMapping map = JaxrpcmapFactory.eINSTANCE.createJavaWSDLMapping();
        jaxrpcmapRes.getContents().add((Object)map);
        this.populateRoot(jaxrpcmapRes.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + this.getProjectLocation();
        this.earFile.extractTo(out, 126);
        this.earFile.close();
    }

    public void test13WebServicesDDPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.currentVersion = 13;
        this.createEAR();
        this.createEJB();
        WsddResource webserDD = (WsddResource)this.ejbFile.getResourceSet().createResource(URI.createURI((String)"META-INF/webservices.xml"));
        webserDD.setVersionID(this.currentVersion);
        this.setVersion(1);
        this.populateRoot(webserDD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + this.getProjectLocation();
        this.earFile.extractTo(out, 126);
        this.earFile.close();
    }

    public void test14WebServicesDDPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.currentVersion = 14;
        this.createEAR();
        this.createEJB();
        WsddResource webserDD = (WsddResource)this.ejbFile.getResourceSet().createResource(URI.createURI((String)"META-INF/webservices.xml"));
        webserDD.getContents().add((Object)WsddFactory.eINSTANCE.createWebServices());
        webserDD.setVersionID(this.currentVersion);
        this.setVersion(2);
        this.populateRoot(webserDD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + this.getProjectLocation();
        this.earFile.extractTo(out, 126);
        this.earFile.close();
    }

    public EObject createInstance(EReference ref, EObject eObject) {
        if (JaxrpcmapPackage.eINSTANCE.getInterfaceMapping().equals(ref.getEType())) {
            return this.createInterfaceMap();
        }
        return super.createInstance(ref, eObject);
    }

    public InterfaceMapping createInterfaceMap() {
        ++this.createdInterfaceMaps;
        if ((this.createdInterfaceMaps & 1) == 0) {
            return JaxrpcmapFactory.eINSTANCE.createServiceEndpointInterfaceMapping();
        }
        return JaxrpcmapFactory.eINSTANCE.createServiceEndpointInterfaceMapping();
    }

    public String getProjectLocation() {
        if (this.currentVersion == 13) {
            return "testOutput/TestWebServices";
        }
        return "testOutput/TestWebServices14";
    }

    public void getEJB() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + this.getProjectLocation() + "/fooWebServices";
        this.ejbFile = this.getArchiveFactory().openEJBJarFile(in);
        WebServicesEMFTest.assertTrue((this.ejbFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEJB() throws DuplicateObjectException {
        this.ejbFile = this.getArchiveFactory().createEJBJarFileInitialized("fooWebServices");
        this.ejbFile = (EJBJarFile)this.earFile.addCopy((ModuleFile)this.ejbFile);
        this.ejbFile.getDeploymentDescriptor().setDisplayName("fooWebServices");
        WebServicesEMFTest.assertTrue((this.ejbFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEAR() {
        String earName = "Test.ear";
        this.earFile = this.getArchiveFactory().createEARFileInitialized(earName);
        WebServicesEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }
}

