/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser.tree;

import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;
import org.eclipse.jem.tests.proxy.initParser.tree.ASTTreeInitStringParserTestHelper;

public class ASTFieldAccessTest
extends AbstractInitParserTestCase {
    public ASTFieldAccessTest(String name) {
        super(name);
    }

    protected ASTTreeInitStringParserTestHelper getTreeParser() {
        return (ASTTreeInitStringParserTestHelper)this.testHelper;
    }

    public void testNonQualifiedFieldAccess() throws Throwable {
        this.getTreeParser().testInitString("Color.red", new String[]{"java.awt.*"}, this.getTreeParser().getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Color").newInstance("java.awt.Color.red"));
    }

    public void testExpressionFieldAccess() throws Throwable {
        this.getTreeParser().testInitString("(Color.red).red", new String[]{"java.awt.*"}, this.getTreeParser().getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Color").newInstance("java.awt.Color.red"));
    }

    public void testNestedFieldAccess() throws Throwable {
        this.getTreeParser().testInitString("ASTNestFieldAccessTestData.acolor.red", new String[]{"org.eclipse.jem.tests.proxy.initParser.tree.ASTNestFieldAccessTestData"}, this.getTreeParser().getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Color").newInstance("java.awt.Color.red"));
    }

    public void testNestedFieldExpressionAccess() throws Throwable {
        this.getTreeParser().testInitString("new ASTNestFieldAccessTestData().acolor.red", new String[]{"org.eclipse.jem.tests.proxy.initParser.tree.ASTNestFieldAccessTestData"}, this.getTreeParser().getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Color").newInstance("java.awt.Color.red"));
    }

    public void testNonstaticFieldAccess() throws Throwable {
        IExpression exp = this.getTreeParser().getRegistry().getBeanProxyFactory().createExpression();
        exp.createFieldAccess(ForExpression.ROOTEXPRESSION, "arect", true);
        exp.createClassInstanceCreation(ForExpression.FIELD_RECEIVER, "org.eclipse.jem.tests.proxy.initParser.tree.ASTNestFieldAccessTestData", 0);
        this.getTreeParser().testInitString("new ASTNestFieldAccessTestData().arect", new String[]{"org.eclipse.jem.tests.proxy.initParser.tree.ASTNestFieldAccessTestData"}, exp.getExpressionValue());
    }

    public void testNonstaticNestedFieldAccess() throws Throwable {
        IExpression exp = this.getTreeParser().getRegistry().getBeanProxyFactory().createExpression();
        exp.createFieldAccess(ForExpression.ROOTEXPRESSION, "x", true);
        exp.createFieldAccess(ForExpression.FIELD_RECEIVER, "arect", true);
        exp.createClassInstanceCreation(ForExpression.FIELD_RECEIVER, "org.eclipse.jem.tests.proxy.initParser.tree.ASTNestFieldAccessTestData", 0);
        this.getTreeParser().testInitString("new ASTNestFieldAccessTestData().arect.x", new String[]{"org.eclipse.jem.tests.proxy.initParser.tree.ASTNestFieldAccessTestData"}, exp.getExpressionValue());
    }
}

