/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.servertype.definition.ArchiveType;
import org.eclipse.jst.server.generic.servertype.definition.ArgumentPair;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.generic.servertype.definition.JndiConnection;
import org.eclipse.jst.server.generic.servertype.definition.LaunchConfiguration;
import org.eclipse.jst.server.generic.servertype.definition.Module;
import org.eclipse.jst.server.generic.servertype.definition.Port;
import org.eclipse.jst.server.generic.servertype.definition.Project;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.Publisher;
import org.eclipse.jst.server.generic.servertype.definition.PublisherData;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.ServerTypeFactory;

public class ServerTypeDefinitionModelTest
extends TestCase {
    private static final String TESTED_SERVER_ID = "org.eclipse.jst.server.generic.runtime.jonas4";
    private ServerRuntime subject = null;

    protected void setUp() throws Exception {
        ServerRuntime[] serverdefs = CorePlugin.getDefault().getServerTypeDefinitionManager().getServerTypeDefinitions();
        int i = 0;
        while (i < serverdefs.length) {
            if (TESTED_SERVER_ID.equals(serverdefs[i].getId())) {
                this.subject = serverdefs[i];
            }
            ++i;
        }
    }

    public void testServerTypeFactory() {
        ServerTypeFactory factory = ServerTypeFactory.eINSTANCE;
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createArchiveType());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createClasspath());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createJndiConnection());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createLaunchConfiguration());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createModule());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createPort());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createProject());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createProperty());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createPublisher());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createPublisherData());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.createServerRuntime());
        ServerTypeDefinitionModelTest.assertNotNull((Object)factory.getServerTypePackage());
    }

    public void testServerRuntime() {
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getClasspath() != null && this.subject.getClasspath().size() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getConfigurationElementNamespace() != null && this.subject.getConfigurationElementNamespace().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getName() != null && this.subject.getName().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getVersion() != null && this.subject.getVersion().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getProperty() != null && this.subject.getProperty().size() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getPort() != null && this.subject.getPort().size() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getModule() != null && this.subject.getModule().size() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertNotNull((Object)this.subject.getProject());
        ServerTypeDefinitionModelTest.assertNotNull((Object)this.subject.getStop());
        ServerTypeDefinitionModelTest.assertNotNull((Object)this.subject.getStart());
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getId() != null && this.subject.getId().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((this.subject.getFilename() != null && this.subject.getFilename().length() > 0 ? 1 : 0) != 0);
        Classpath cp = (Classpath)this.subject.getClasspath().get(0);
        ServerTypeDefinitionModelTest.assertEquals((Object)cp, (Object)this.subject.getClasspath(cp.getId()));
        Module module = (Module)this.subject.getModule().get(0);
        ServerTypeDefinitionModelTest.assertEquals((Object)module, (Object)this.subject.getModule(module.getType()));
        ServerTypeDefinitionModelTest.assertNotNull((Object)this.subject.getPublisher("org.eclipse.jst.server.generic.antpublisher"));
    }

    public void testSetServerRuntime() {
        this.subject.setId(TESTED_SERVER_ID);
        this.subject.setConfigurationElementNamespace("test.namespace");
        this.subject.setFilename("test.filename");
        HashMap testMap = new HashMap();
        this.subject.setPropertyValues(testMap);
        ServerTypeDefinitionModelTest.assertEquals((String)TESTED_SERVER_ID, (String)this.subject.getId());
        ServerTypeDefinitionModelTest.assertEquals((String)"test.namespace", (String)this.subject.getConfigurationElementNamespace());
        ServerTypeDefinitionModelTest.assertEquals((String)"test.filename", (String)this.subject.getFilename());
    }

    public void testClasspath() {
        Classpath cp = (Classpath)this.subject.getClasspath().get(0);
        ServerTypeDefinitionModelTest.assertTrue((cp.getId() != null && cp.getId().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((cp.getArchive() != null && cp.getArchive().size() > 0 ? 1 : 0) != 0);
        ArchiveType archiveType = (ArchiveType)cp.getArchive().get(0);
        ServerTypeDefinitionModelTest.assertTrue((archiveType.getPath() != null && archiveType.getPath().length() > 0 ? 1 : 0) != 0);
    }

    public void testLaunchConfiguration() {
        LaunchConfiguration lcfg = this.subject.getStart();
        ServerTypeDefinitionModelTest.assertNotNull((Object)lcfg);
        ServerTypeDefinitionModelTest.assertTrue((lcfg.getMainClass() != null && lcfg.getMainClass().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((lcfg.getMainClass() != null && lcfg.getExternal().isEmpty() ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((lcfg.getMainClass() != null && lcfg.getDebugPort() == null ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((lcfg.getClasspathReference() != null && lcfg.getClasspathReference().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((lcfg.getProgramArguments() != null && !lcfg.getProgramArguments().isEmpty() ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((lcfg.getVmParameters() != null && !lcfg.getVmParameters().isEmpty() ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((lcfg.getWorkingDirectory() != null && lcfg.getWorkingDirectory().length() > 0 ? 1 : 0) != 0);
    }

    public void testModule() {
        Module module = (Module)this.subject.getModule().get(0);
        ServerTypeDefinitionModelTest.assertNotNull((Object)module);
        ServerTypeDefinitionModelTest.assertTrue((module.getPublishDir() != null && module.getPublishDir().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((module.getPublisherReference() != null && module.getPublisherReference().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((module.getType() != null && module.getType().length() > 0 ? 1 : 0) != 0);
    }

    public void testPort() {
        Port port = (Port)this.subject.getPort().get(0);
        ServerTypeDefinitionModelTest.assertNotNull((Object)port);
        ServerTypeDefinitionModelTest.assertNotNull((Object)port.getName());
        ServerTypeDefinitionModelTest.assertTrue((port.getNo() != null && port.getNo().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((port.getProtocol() != null && port.getProtocol().length() > 0 ? 1 : 0) != 0);
    }

    public void testProject() {
        Project project = this.subject.getProject();
        ServerTypeDefinitionModelTest.assertNotNull((Object)project);
        ServerTypeDefinitionModelTest.assertNotNull((Object)project.getClasspathReference());
    }

    public void testProperty() {
        Property property = (Property)this.subject.getProperty().get(0);
        ServerTypeDefinitionModelTest.assertNotNull((Object)property);
        ServerTypeDefinitionModelTest.assertTrue((property.getContext() != null && property.getContext().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((property.getDefault() != null && property.getDefault().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((property.getId() != null && property.getId().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((property.getLabel() != null && property.getLabel().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((property.getType() != null && property.getType().length() > 0 ? 1 : 0) != 0);
    }

    public void testPublisher() {
        Publisher publisher = (Publisher)this.subject.getPublisher().get(0);
        ServerTypeDefinitionModelTest.assertNotNull((Object)publisher);
        ServerTypeDefinitionModelTest.assertTrue((publisher.getId() != null && publisher.getId().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((publisher.getPublisherdata() != null && publisher.getPublisherdata().size() > 0 ? 1 : 0) != 0);
        PublisherData data = (PublisherData)publisher.getPublisherdata().get(0);
        ServerTypeDefinitionModelTest.assertNotNull((Object)data);
        ServerTypeDefinitionModelTest.assertTrue((data.getDataname() != null && data.getDataname().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((data.getDatavalue() != null && data.getDatavalue().length() > 0 ? 1 : 0) != 0);
    }

    public void testJNDIConnection() {
        JndiConnection jndi = this.subject.getJndiConnection();
        ServerTypeDefinitionModelTest.assertNotNull((Object)jndi);
        ServerTypeDefinitionModelTest.assertTrue((jndi.getProviderUrl() != null && jndi.getProviderUrl().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertTrue((jndi.getInitialContextFactory() != null && jndi.getInitialContextFactory().length() > 0 ? 1 : 0) != 0);
        ServerTypeDefinitionModelTest.assertNotNull((Object)jndi.getJndiProperty());
        if (jndi.getJndiProperty().size() > 0) {
            ArgumentPair property = (ArgumentPair)jndi.getJndiProperty().get(0);
            ServerTypeDefinitionModelTest.assertNotNull((Object)property.getName());
            ServerTypeDefinitionModelTest.assertNotNull((Object)property.getValue());
        }
    }
}

