/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.parser.internal.JSPTokenizer;

public class JSPTokenizerTest
extends TestCase {
    private JSPTokenizer tokenizer = null;

    private void reset(Reader in) {
        this.tokenizer.reset(in);
    }

    private void reset(String filename) {
        InputStreamReader fileReader = null;
        try {
            fileReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename), "utf8");
        }
        catch (IOException iOException) {}
        if (fileReader == null) {
            JSPTokenizerTest.fail();
        }
        BufferedReader reader = new BufferedReader(fileReader);
        this.reset(reader);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tokenizer = new JSPTokenizer();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tokenizer = null;
    }

    public void test144807_AttrName() {
        String input = "";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            JSPTokenizerTest.fail((String)e.getMessage());
        }
    }

    public void test144807_AttrValue() {
        String input = "<a b=";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            JSPTokenizerTest.fail((String)e.getMessage());
        }
    }

    public void test144807_Equals() {
        String input = "<a b";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            JSPTokenizerTest.fail((String)e.getMessage());
        }
    }

    public void testInsertComment() {
        this.reset("jspcomment01.jsp");
        try {
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException iOException) {
        }
        catch (StackOverflowError e) {
            JSPTokenizerTest.fail((String)e.getMessage());
            return;
        }
        JSPTokenizerTest.assertTrue((boolean)true);
    }
}

