/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests;

import java.util.ResourceBundle;
import junit.framework.TestCase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IClassLoaderProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceBundleProvider;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.swt.graphics.Image;

public class ModelProviderAdapterTests
extends TestCase {
    private final String JSF_HTML_URI = "http://java.sun.com/jsf/html";
    private final String IMAGES_BASE = "/icons/palette/JSFHTML/small/";
    private Trait _trait;

    protected void setUp() throws Exception {
        super.setUp();
        ITaglibDomainMetaDataModelContext context = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext(null, (String)"http://java.sun.com/jsf/html");
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)context);
        ModelProviderAdapterTests.assertNotNull((Object)model);
        this._trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"display-label");
        ModelProviderAdapterTests.assertNotNull((Object)this._trait);
    }

    public void testImageDescriptorProvider() {
        IImageDescriptorProvider imageProvider = (IImageDescriptorProvider)this._trait.getSourceModelProvider().getAdapter(IImageDescriptorProvider.class);
        ModelProviderAdapterTests.assertNotNull((Object)imageProvider);
        ImageDescriptor id = imageProvider.getImageDescriptor("/icons/palette/JSFHTML/small/JSF_COMMANDBUTTON");
        ModelProviderAdapterTests.assertNotNull((Object)id);
        Image image = id.createImage();
        ModelProviderAdapterTests.assertNotNull((Object)image);
        image.dispose();
    }

    public void testResourceBundleProvider() {
        IResourceBundleProvider bundleProvider = (IResourceBundleProvider)this._trait.getSourceModelProvider().getAdapter(IResourceBundleProvider.class);
        ModelProviderAdapterTests.assertNotNull((Object)bundleProvider);
        ResourceBundle bundle = bundleProvider.getResourceBundle();
        ModelProviderAdapterTests.assertNotNull((Object)bundle);
        ModelProviderAdapterTests.assertNotNull((Object)bundle.getString("JSFHTML.display-label"));
        ModelProviderAdapterTests.assertEquals((String)"JSF HTML", (String)bundle.getString("JSFHTML.display-label"));
        ModelProviderAdapterTests.assertNotNull((Object)bundle.getString("column.display-label"));
        ModelProviderAdapterTests.assertEquals((String)"Column", (String)bundle.getString("column.display-label"));
        ITaglibDomainMetaDataModelContext context = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext(null, (String)"RootOfPluginTest");
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)context);
        ModelProviderAdapterTests.assertNotNull((Object)model);
        this._trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"T1");
        ModelProviderAdapterTests.assertNotNull((Object)this._trait);
        bundleProvider = (IResourceBundleProvider)this._trait.getSourceModelProvider().getAdapter(IResourceBundleProvider.class);
        ModelProviderAdapterTests.assertNotNull((Object)bundleProvider);
        bundle = bundleProvider.getResourceBundle();
        ModelProviderAdapterTests.assertNotNull((Object)bundle.getString("NLS"));
        ModelProviderAdapterTests.assertEquals((String)"This is externalized text", (String)bundle.getString("NLS"));
    }

    public void testClassloaderProvider() {
        IClassLoaderProvider classLoaderProvider = (IClassLoaderProvider)this._trait.getSourceModelProvider().getAdapter(IClassLoaderProvider.class);
        ModelProviderAdapterTests.assertNotNull((Object)classLoaderProvider);
        Class klass = classLoaderProvider.loadClass("java.lang.String");
        ModelProviderAdapterTests.assertNotNull((Object)klass);
        klass = classLoaderProvider.loadClass("org.eclipse.jst.pagedesigner.jsf.ui.util.JSFUIPluginResourcesUtil");
        ModelProviderAdapterTests.assertNotNull((Object)klass);
    }
}

