/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.taglibprocessing;

import junit.framework.Assert;
import org.eclipse.jst.jsf.metadata.tests.taglibprocessing.TaglibProcessingTestCase;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IDefaultValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;

public class LengthTypeTest
extends TaglibProcessingTestCase {
    public void testPossibleValues() {
        Assert.assertNotNull((Object)this.possibleValueAdapters);
        Assert.assertTrue((boolean)this.possibleValueAdapters.isEmpty());
    }

    public void testValidValues() {
        Assert.assertNotNull((Object)this.validValuesAdapters);
        Assert.assertFalse((boolean)this.validValuesAdapters.isEmpty());
        IValidValues vv = (IValidValues)this.validValuesAdapters.get(0);
        Assert.assertTrue((boolean)vv.isValidValue("0"));
        Assert.assertTrue((vv.getValidationMessages().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)vv.isValidValue("100"));
        Assert.assertTrue((boolean)vv.isValidValue("101"));
        Assert.assertFalse((boolean)vv.isValidValue("False"));
        Assert.assertFalse((boolean)vv.isValidValue("False"));
        Assert.assertFalse((vv.getValidationMessages().size() == 0 ? 1 : 0) != 0);
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("-1"));
        Assert.assertTrue((vv.getValidationMessages().size() == 1 ? 1 : 0) != 0);
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("555555555555555555"));
        Assert.assertTrue((vv.getValidationMessages().size() == 1 ? 1 : 0) != 0);
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("555f9"));
        Assert.assertTrue((vv.getValidationMessages().size() == 1 ? 1 : 0) != 0);
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("2e1"));
        Assert.assertTrue((vv.getValidationMessages().size() == 1 ? 1 : 0) != 0);
        vv.getValidationMessages().clear();
        Assert.assertTrue((boolean)vv.isValidValue("20%"));
        Assert.assertFalse((boolean)vv.isValidValue("%20"));
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("2%0"));
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("%"));
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("1x"));
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("x"));
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("-10%"));
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("-20"));
        vv.getValidationMessages().clear();
        Assert.assertTrue((boolean)vv.isValidValue("100%"));
    }

    public void testDefaultValues() {
        Assert.assertNotNull((Object)this.defaultValueAdapters);
        Assert.assertFalse((boolean)this.defaultValueAdapters.isEmpty());
        IDefaultValue dv = (IDefaultValue)this.defaultValueAdapters.get(0);
        Assert.assertTrue((dv.getDefaultValue() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dv.getDefaultValue().equals("100%"));
    }

    public void testCreateValues() {
        Assert.assertNotNull((Object)this.createValuesAdapters);
        Assert.assertTrue((boolean)this.createValuesAdapters.isEmpty());
    }

    public void testGetExpectedReturnType() {
        Assert.assertNotNull((Object)this.validELValuesAdapters);
        IValidELValues vvel = (IValidELValues)this.validELValuesAdapters.get(0);
        try {
            Assert.assertEquals((String)"int", (String)vvel.getExpectedRuntimeType().toUserReadableString());
        }
        catch (ELIsNotValidException eLIsNotValidException) {
            LengthTypeTest.fail((String)"testGetExpectedReturnType");
        }
    }
}

