/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy;

import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;

public class TestCallback
implements ICallback {
    Object tester;
    ProxyFactoryRegistry registry;
    int counter = 0;
    private boolean stoppedTest;
    private Class badParmType = null;
    private int badParmValue;
    private int goodParmValue;
    private String badMsg;
    static /* synthetic */ Class class$0;

    public void testCompleted() {
        if (this.badParmType != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TestCase.assertEquals((Object)clazz, (Object)this.badParmType);
        }
        if (this.badParmValue != 0) {
            TestCase.assertEquals((int)this.goodParmValue, (int)this.badParmValue);
        }
        if (this.badMsg != null) {
            TestCase.fail((String)this.badMsg);
        }
        TestCase.assertEquals((int)2, (int)this.counter);
    }

    public TestCallback(Object t, ProxyFactoryRegistry registry) {
        this.tester = t;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object calledBack(int msgID, IBeanProxy parm) {
        Object object = this.tester;
        synchronized (object) {
            if (this.stoppedTest) {
                return null;
            }
        }
        if (msgID != 0) {
            this.badMsg = "Msgid " + msgID + " is incorrect. It should be zero.";
            this.stopTest();
            return null;
        }
        if (!(parm instanceof IIntegerBeanProxy)) {
            this.badParmType = parm.getClass();
            this.stopTest();
            return null;
        }
        int pv = ((IIntegerBeanProxy)parm).intValue();
        if (++this.counter != pv) {
            this.badParmValue = pv;
            this.goodParmValue = this.counter;
            this.stopTest();
            return null;
        }
        if (this.counter != 2) return null;
        this.stopTest();
        return null;
    }

    public Object calledBack(int msgID, Object parm) {
        if (msgID != 1) {
            this.badMsg = "Msgid " + msgID + " is incorrect. It should be one.";
            this.stopTest();
        } else if (parm instanceof Integer) {
            IMethodProxy currentThreadMethod = this.registry.getMethodProxyFactory().getMethodProxy("java.lang.Thread", "currentThread", null);
            IBeanProxy thread = currentThreadMethod.invokeCatchThrowableExceptions(null);
            IMethodProxy hashcodeMethod = this.registry.getMethodProxyFactory().getMethodProxy("java.lang.Object", "hashCode", null);
            IBeanProxy threadID = hashcodeMethod.invokeCatchThrowableExceptions(thread);
            if (threadID instanceof INumberBeanProxy) {
                if (!parm.equals(((INumberBeanProxy)threadID).numberValue())) {
                    this.badMsg = "ThreadID returned from call not match parm sent it. Means callback not on same thread.";
                    this.stopTest();
                }
            } else {
                this.badMsg = "ThreadID returned from call is not valid.";
                this.stopTest();
            }
        } else {
            this.badMsg = "Parm is invalid for calledBack with Object";
            this.stopTest();
        }
        return null;
    }

    public Object calledBack(int msgID, Object[] parms) {
        this.badMsg = "Failed Callback Test. Shouldn't have gotton to multi-parms";
        this.stopTest();
        return null;
    }

    public void calledBackStream(int msgID, InputStream in) {
        this.badMsg = "Failed Callback Test. Shouldn't have gotton to input stream";
        this.stopTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTest() {
        Object object = this.tester;
        synchronized (object) {
            this.stoppedTest = true;
            this.tester.notify();
        }
    }
}

