/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;

public class ArchiveTestsUtil {
    public static final String[] ARCHIVE_EXTENSIONS = new String[]{".jar", ".war", ".rar"};

    public static boolean compareFiles(File a, File b) throws IOException {
        FileInputStream streamA = null;
        InputStream streamB = null;
        try {
            streamA = new FileInputStream(a);
            streamB = new FileInputStream(b);
            boolean bl = ArchiveTestsUtil.compareStreams(streamA, streamB);
            return bl;
        }
        finally {
            try {
                if (streamA != null) {
                    ((InputStream)streamA).close();
                }
            }
            finally {
                if (streamB != null) {
                    streamB.close();
                }
            }
        }
    }

    public static void compareArchives(IPath a, IPath b) throws ArchiveOpenFailureException, IOException {
        IArchive aArchive = null;
        IArchive bArchive = null;
        try {
            aArchive = JavaEEArchiveUtilities.INSTANCE.openArchive(a);
            bArchive = JavaEEArchiveUtilities.INSTANCE.openArchive(b);
            ArchiveTestsUtil.compareArchives(aArchive, bArchive);
        }
        finally {
            if (aArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(aArchive);
            }
            if (bArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(bArchive);
            }
        }
    }

    public static void compareArchives(IArchive a, IArchive b) throws ArchiveOpenFailureException, IOException {
        IArchiveResource bRes;
        List aResources = a.getArchiveResources();
        ArrayList bResources = new ArrayList();
        bResources.addAll(b.getArchiveResources());
        for (IArchiveResource aRes : aResources) {
            if (aRes.getPath().equals((Object)IArchive.EMPTY_MODEL_PATH)) {
                if (!b.containsArchiveResource(aRes.getPath())) continue;
                bResources.remove(b.getArchiveResource(aRes.getPath()));
                continue;
            }
            Assert.assertTrue((String)("IArchive B " + b.getPath() + " is missing " + aRes.getPath()), (boolean)b.containsArchiveResource(aRes.getPath()));
            bRes = b.getArchiveResource(aRes.getPath());
            Assert.assertNotNull((String)("IArchive B " + b.getPath() + " is missing " + aRes.getPath()), (Object)bRes);
            Assert.assertTrue((boolean)bResources.remove(bRes));
            if (aRes.getType() != bRes.getType()) {
                boolean throwError = false;
                throwError = a.getLoadAdapter().getClass() == b.getLoadAdapter().getClass() ? true : aRes.getType() != 2 && bRes.getType() != 2;
                if (throwError) {
                    Assert.assertEquals((String)("IArchiveResource types differ for " + aRes.getPath()), (int)aRes.getType(), (int)bRes.getType());
                }
            }
            InputStream aIn = null;
            InputStream bIn = null;
            try {
                boolean isDirectory;
                aIn = aRes.getInputStream();
                bIn = bRes.getInputStream();
                boolean bl = isDirectory = aRes.getType() == 1;
                if (isDirectory) {
                    Assert.assertNull((Object)aIn);
                    Assert.assertNull((Object)bIn);
                    continue;
                }
                Assert.assertNotNull((String)("Failed to get IO stream from A for " + aRes.getPath()), (Object)aIn);
                Assert.assertNotNull((String)("Failed to get IO stream from B for " + bRes.getPath()), (Object)bIn);
                boolean compareArchives = false;
                String pathString = aRes.getPath().toString();
                int i = 0;
                while (i < ARCHIVE_EXTENSIONS.length && !compareArchives) {
                    if (pathString.endsWith(ARCHIVE_EXTENSIONS[i])) {
                        compareArchives = true;
                    }
                    ++i;
                }
                if (compareArchives) {
                    ArchiveTestsUtil.compareArchives(a.getNestedArchive(aRes), b.getNestedArchive(bRes));
                    continue;
                }
                if (pathString.endsWith(".class")) continue;
                Assert.assertTrue((String)("IO Streams are not the same for " + aRes.getPath()), (boolean)ArchiveTestsUtil.compareStreams(aIn, bIn));
            }
            finally {
                if (aIn != null) {
                    try {
                        aIn.close();
                    }
                    finally {
                        if (bIn != null) {
                            bIn.close();
                        }
                    }
                }
            }
        }
        if (!bResources.isEmpty()) {
            StringBuffer error = new StringBuffer("IArchive B contains");
            int i = 0;
            while (i < bResources.size()) {
                bRes = (IArchiveResource)bResources.get(i);
                error.append(" " + bRes.getPath());
                ++i;
            }
            Assert.fail((String)error.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compareStreams(InputStream a, InputStream b) throws IOException {
        try {
            BufferedInputStream buffA = new BufferedInputStream(a);
            BufferedInputStream buffB = new BufferedInputStream(b);
            int buffSize = 1024;
            byte[] bytesA = new byte[buffSize];
            byte[] bytesB = new byte[buffSize];
            int aRead = -1;
            int bRead = -1;
            while (-1 != (aRead = buffA.read(bytesA))) {
                bRead = buffB.read(bytesB);
                if (aRead != bRead) {
                    String aStr = new String(bytesA, 0, aRead);
                    String bStr = new String(bytesB, 0, bRead);
                    ArchiveTestsUtil.printCompareError(aStr, bStr);
                    return false;
                }
                int i = 0;
                while (i < aRead - 1) {
                    if (bytesA[i] != bytesB[i]) {
                        String aStr = new String(bytesA, 0, aRead);
                        String bStr = new String(bytesB, 0, bRead);
                        ArchiveTestsUtil.printCompareError(aStr, bStr);
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        finally {
            try {
                a.close();
            }
            finally {
                b.close();
            }
        }
    }

    private static void printCompareError(String aStr, String bStr) {
        aStr = aStr.replaceAll("\n", "<LF>");
        bStr = bStr.replaceAll("\n", "<LF>");
        aStr = aStr.replaceAll("\r", "<CR>");
        bStr = bStr.replaceAll("\r", "<CR>");
        aStr = aStr.replaceAll(" ", "<SP>");
        bStr = bStr.replaceAll(" ", "<SP>");
        System.err.println("A=[" + aStr + "]");
        System.err.println("B=[" + bStr + "]");
    }
}

